/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.plugins.document.CompressedDocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentPropertyStateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentPropertyStateFactory.class);

    public static PropertyState createPropertyState(DocumentNodeStore store, String name, String value, Compression compression) {
        if (compression != null && !compression.equals(Compression.NONE) && CompressedDocumentPropertyState.getCompressionThreshold() != -1 && value.length() > CompressedDocumentPropertyState.getCompressionThreshold()) {
            try {
                return new CompressedDocumentPropertyState(store, name, value, compression);
            }
            catch (Exception e) {
                LOG.warn("Failed to compress property {} value: ", (Object)name, (Object)e);
                return new DocumentPropertyState(store, name, value);
            }
        }
        return new DocumentPropertyState(store, name, value);
    }

    public static PropertyState createPropertyState(DocumentNodeStore store, String name, String value) {
        return DocumentPropertyStateFactory.createPropertyState(store, name, value, Compression.GZIP);
    }
}

