/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.node.service;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.node.dao.NodeDAO;
import org.silverpeas.core.node.dao.NodeI18NDAO;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodeI18NDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.model.NodeRuntimeException;
import org.silverpeas.core.node.notification.NodeEventNotifier;
import org.silverpeas.core.node.service.NodeDeletion;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultNodeService
implements NodeService,
ComponentInstanceDeletion {
    private static final SettingBundle nodeSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.node.nodeSettings");
    @Inject
    private NodeDAO nodeDAO;
    @Inject
    private NodeDeletion nodeDeletion;
    @Inject
    private NodeEventNotifier notifier;

    @Override
    @Transactional
    public void delete(String componentInstanceId) {
        try {
            NodeI18NDAO.deleteComponentInstanceData(componentInstanceId);
            this.nodeDAO.deleteComponentInstanceData(componentInstanceId);
        }
        catch (SQLException e) {
            throw new NodeRuntimeException(e);
        }
    }

    private NodeDetail findNode(NodePK pk) {
        Connection con = this.getConnection();
        try {
            NodeDetail nodeDetail = this.nodeDAO.selectByPrimaryKey(con, pk);
            if (nodeDetail != null) {
                NodeDetail nodeDetail2 = nodeDetail;
                return nodeDetail2;
            }
            try {
                throw new NodeRuntimeException("Node not found nodeId = " + pk.getId());
            }
            catch (SQLException e) {
                throw new NodeRuntimeException(e);
            }
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public NodeDetail getDetailByNameAndFatherId(NodePK pk, String name, int nodeFatherId) {
        Connection con = this.getConnection();
        try {
            NodeDetail nodeDetail = this.nodeDAO.selectByNameAndFatherId(con, pk, name, nodeFatherId);
            return nodeDetail;
        }
        catch (SQLException e) {
            throw new NodeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.SUPPORTS)
    public NodeDetail getDetail(NodePK pk) {
        try {
            NodeDetail nodeDetail = this.findNode(pk);
            if (!"file_link".equals(nodeDetail.getNodeType())) {
                nodeDetail.setChildrenDetails(this.getChildrenDetails(pk));
            }
            NodeI18NDetail nodeI18NDetail = new NodeI18NDetail(nodeDetail.getLanguage(), nodeDetail.getName(), nodeDetail.getDescription());
            nodeDetail.addTranslation(nodeI18NDetail);
            List<NodeI18NDetail> translations = this.getTranslations(pk.getId());
            Iterator<NodeI18NDetail> iterator = translations.iterator();
            while (iterator.hasNext()) {
                NodeI18NDetail translation;
                nodeI18NDetail = translation = iterator.next();
                nodeDetail.addTranslation(nodeI18NDetail);
            }
            return nodeDetail;
        }
        catch (Exception re) {
            throw new NodeRuntimeException(re);
        }
    }

    private List<NodeI18NDetail> getTranslations(String nodeId) {
        Connection con = this.getConnection();
        try {
            List<NodeI18NDetail> list = NodeI18NDAO.getTranslations(con, nodeId);
            return list;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<NodeDetail> getTree(NodePK pk) {
        Connection con = this.getConnection();
        try {
            List<NodeDetail> list = this.nodeDAO.getTree(con, pk);
            return list;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<NodeDetail> getSubTree(NodePK pk) {
        return this.getSubTree(pk, null, 0, null);
    }

    @Override
    public List<NodeDetail> getSubTree(NodePK pk, String sorting) {
        return this.getSubTree(pk, null, 0, sorting);
    }

    @Override
    public List<NodeDetail> getSubTreeByStatus(NodePK pk, String status) {
        return this.getSubTree(pk, status, 0, null);
    }

    @Override
    public List<NodeDetail> getSubTreeByStatus(NodePK pk, String status, String sorting) {
        return this.getSubTree(pk, status, 0, sorting);
    }

    @Override
    public List<NodeDetail> getSubTreeByLevel(NodePK pk, int level) {
        return this.getSubTree(pk, null, level, null);
    }

    @Override
    public List<NodeDetail> getSubTreeByLevel(NodePK pk, int level, String sorting) {
        return this.getSubTree(pk, null, level, sorting);
    }

    @Override
    public List<NodeDetail> getSubTree(NodePK pk, String status, int level, String sorting) {
        Connection con = this.getConnection();
        try {
            List<NodeDetail> headers = this.nodeDAO.getAllHeaders(con, pk, sorting, level);
            NodeDetail root = this.nodeDAO.loadRow(con, pk);
            root.setChildrenDetails(new ArrayList<NodeDetail>());
            HashMap<String, NodeDetail> tree = new HashMap<String, NodeDetail>(headers.size());
            tree.put(root.getNodePK().getId(), root);
            for (NodeDetail header : headers) {
                header.setChildrenDetails(new ArrayList<NodeDetail>());
                tree.put(header.getNodePK().getId(), header);
            }
            for (NodeDetail header : headers) {
                NodeDetail father = (NodeDetail)tree.get(header.getFatherPK().getId());
                if (father == null) continue;
                father.getChildrenDetails().add(header);
            }
            ArrayList<NodeDetail> result = new ArrayList<NodeDetail>();
            if (level == 0) {
                root = (NodeDetail)tree.get(root.getNodePK().getId());
                this.processNode(result, root);
            } else {
                result.addAll(headers);
            }
            ArrayList<NodeDetail> arrayList = result;
            return arrayList;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void processNode(List<NodeDetail> result, NodeDetail node) {
        result.add(node);
        Collection<NodeDetail> children = node.getChildrenDetails();
        if (children != null) {
            for (NodeDetail child : children) {
                this.processNode(result, child);
            }
        }
    }

    @Override
    @Transactional
    public void moveNode(NodePK nodePK, NodePK toNode) {
        this.moveNode(nodePK, toNode, false);
    }

    @Override
    @Transactional
    public void moveNode(NodePK nodeToMove, NodePK toNode, boolean preserveRights) {
        NodeDetail root = this.getDetail(toNode);
        String newRootPath = root.getPath() + toNode.getId() + "/";
        String oldRootPath = null;
        Connection con = this.getConnection();
        try {
            List<NodeDetail> tree = this.getSubTree(nodeToMove);
            NodeDetail after = tree.get(0);
            NodeDetail before = new NodeDetail(after);
            before.setNodePK(new NodePK(nodeToMove.getId(), nodeToMove.getComponentInstanceId()));
            for (int t = 0; t < tree.size(); ++t) {
                NodeDetail node = tree.get(t);
                this.deleteIndex(node.getNodePK());
                if (t == 0) {
                    oldRootPath = node.getPath();
                    node.setFatherPK(toNode);
                    node.setOrder(root.getChildrenNumber());
                }
                String newPath = node.getPath().replaceAll(oldRootPath, newRootPath);
                node.setPath(newPath);
                node.setLevel(StringUtils.countMatches((CharSequence)newPath, (CharSequence)"/"));
                node.getNodePK().setComponentName(toNode.getInstanceId());
                if (preserveRights) {
                    if (t == 0 && !node.haveLocalRights()) {
                        node.setRightsDependsOn(root.getRightsDependsOn());
                    }
                } else {
                    node.setRightsDependsOn("-1");
                }
                node.setUseId(true);
                this.nodeDAO.moveNode(con, node);
                this.createIndex(node, true);
            }
            this.nodeDAO.unvalidateTree(con, nodeToMove);
            this.nodeDAO.unvalidateTree(con, toNode);
            this.notifier.notifyEventOn(ResourceEvent.Type.MOVE, new NodeDetail[]{before, after});
        }
        catch (Exception e) {
            throw new NodeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public NodeDetail getHeader(NodePK pk, boolean getTranslations) {
        Connection con = this.getConnection();
        try {
            NodeDetail nodeDetail = this.nodeDAO.loadRow(con, pk, getTranslations);
            return nodeDetail;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public NodeDetail getHeader(NodePK pk) {
        Connection con = this.getConnection();
        try {
            NodeDetail nodeDetail = this.nodeDAO.loadRow(con, pk);
            return nodeDetail;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional
    public void setDetail(NodeDetail nd) {
        NodeDetail oldNodeDetail = this.getHeader(nd.getNodePK());
        Connection con = this.getConnection();
        try {
            if (nd.isRemoveTranslation()) {
                this.removeTranslation(con, oldNodeDetail, nd);
            } else {
                this.addOrUpdateTranslation(con, oldNodeDetail, nd);
            }
            this.createIndex(nd.getNodePK());
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void addOrUpdateTranslation(Connection con, NodeDetail oldNodeDetail, NodeDetail nd) throws SQLException {
        if (nd.getLanguage() != null) {
            String newLanguage;
            String defaultLanguage = oldNodeDetail.getLanguage();
            if (defaultLanguage == null) {
                nd.setLanguage(I18NHelper.DEFAULT_LANGUAGE);
                defaultLanguage = nd.getLanguage();
            }
            if (!(newLanguage = nd.getLanguage()).equals(defaultLanguage)) {
                NodeI18NDetail translation = new NodeI18NDetail(nd.getLanguage(), nd.getName(), nd.getDescription());
                translation.setNodeId(nd.getId());
                String translationId = nd.getTranslationId();
                if (StringUtil.isDefined((String)translationId) && !"-1".equals(translationId)) {
                    translation.setId(translationId);
                    translation.setNodeId(nd.getId());
                    NodeI18NDAO.updateTranslation(con, translation);
                } else {
                    NodeI18NDAO.saveTranslation(con, translation);
                }
                this.nodeDAO.unvalidateTree(con, nd.getNodePK());
            } else {
                this.update(con, this.updateNodeDetailWith(oldNodeDetail, nd));
            }
        } else {
            this.update(con, this.updateNodeDetailWith(oldNodeDetail, nd));
        }
    }

    private void removeTranslation(Connection con, NodeDetail oldNodeDetail, NodeDetail nd) throws SQLException {
        if ("-1".equals(nd.getTranslationId())) {
            List<NodeI18NDetail> translations = NodeI18NDAO.getTranslations(con, nd.getId());
            if (!translations.isEmpty()) {
                NodeI18NDetail translation = translations.get(0);
                nd.setLanguage(translation.getLanguage());
                nd.setName(translation.getName());
                nd.setDescription(translation.getDescription());
                NodeI18NDAO.removeTranslation(con, translation.getId());
                this.update(con, this.updateNodeDetailWith(oldNodeDetail, nd));
            }
        } else {
            NodeI18NDAO.removeTranslation(con, nd.getTranslationId());
        }
    }

    @Override
    @Transactional
    public void deleteNode(NodePK pk) {
        Connection connection = this.getConnection();
        try {
            this.nodeDeletion.deleteNodes(pk, connection, pk1 -> WysiwygController.deleteWysiwygAttachments(pk1.getInstanceId(), "Node_" + pk1.getId()));
        }
        catch (Exception re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    @Override
    @Transactional
    public void removeNode(NodeDetail nodeDetail) {
        try (Connection connection = this.getConnection();){
            User remover = User.getCurrentRequester();
            this.nodeDAO.removeNode(connection, nodeDetail, remover.getId());
        }
        catch (Exception re) {
            throw new NodeRuntimeException(re);
        }
    }

    @Override
    @Transactional
    public void restoreNode(NodeDetail node) {
        try (Connection connection = this.getConnection();){
            this.nodeDAO.restoreNode(connection, node);
        }
        catch (Exception re) {
            throw new NodeRuntimeException(re);
        }
    }

    @Override
    public NodePath getPath(NodePK pk) {
        Connection con = this.getConnection();
        try {
            NodePath nodePath = this.nodeDAO.getNodePath(con, pk);
            return nodePath;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<NodeDetail> getChildrenDetails(NodePK pk) {
        Connection con = this.getConnection();
        try {
            Collection<NodeDetail> collection = this.nodeDAO.getChildrenDetails(con, pk);
            return collection;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<NodeDetail> getHeadersByLevel(NodePK pk, int level) {
        Connection con = this.getConnection();
        try {
            List<NodeDetail> list = this.nodeDAO.getHeadersByLevel(con, pk, level);
            return list;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<NodeDetail> getAllNodes(NodePK nodePK) {
        Connection con = this.getConnection();
        try {
            List<NodeDetail> list = this.nodeDAO.getAllHeaders(con, nodePK);
            return list;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<NodeDetail> getMinimalDataByInstances(Collection<String> instanceIds) {
        List<NodeDetail> list;
        block8: {
            Connection con = this.getConnection();
            try {
                list = this.nodeDAO.getMinimalDataByInstances(con, instanceIds);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new NodeRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }

    @Override
    @Transactional
    public NodeDetail createNode(NodeDetail node) {
        NodePK parentPK = node.getFatherPK();
        if (parentPK != null) {
            NodeDetail parent = this.getHeader(parentPK);
            node.setPath(parent.getFullPath());
            node.setLevel(parent.getLevel() + 1);
        } else {
            node.setPath("/");
        }
        if (node.getLanguage() == null) {
            node.setLanguage(I18NHelper.DEFAULT_LANGUAGE);
        }
        try {
            NodePK newNodePK = this.save(node);
            NodeDetail newNode = this.getDetail(newNodePK);
            this.createIndex(newNode, false);
            return newNode;
        }
        catch (Exception e) {
            throw new NodeRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public NodeDetail createNode(NodeDetail nd, NodeDetail fatherDetail) {
        try {
            if (!"file_link".equals(nd.getNodeType())) {
                nd.setPath(fatherDetail.getPath() + fatherDetail.getNodePK().getId() + "/");
            }
            nd.setLevel(fatherDetail.getLevel() + 1);
            nd.setFatherPK(fatherDetail.getNodePK());
            if (nd.getLanguage() == null) {
                nd.setLanguage(I18NHelper.DEFAULT_LANGUAGE);
            }
            NodePK newNodePK = this.save(nd);
            NodeDetail newNode = this.getDetail(newNodePK);
            this.createIndex(newNode, false);
            return newNode;
        }
        catch (Exception re) {
            throw new NodeRuntimeException(re);
        }
    }

    private NodePK save(NodeDetail nd) {
        NodePK newNodePK;
        Connection con = this.getConnection();
        try {
            newNodePK = this.nodeDAO.insertRow(con, nd);
            String rightsDependsOn = nd.getRightsDependsOn();
            if (rightsDependsOn.equals("0")) {
                rightsDependsOn = newNodePK.getId();
            }
            if (nd.haveRights()) {
                this.nodeDAO.updateRightsDependency(con, newNodePK, rightsDependsOn);
            }
            nd.setNodePK(newNodePK);
            this.createTranslations(con, nd);
        }
        catch (SQLException e) {
            throw new NodeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
        return newNodePK;
    }

    private void updateNodeDetail(NodeDetail detail) {
        Connection con = this.getConnection();
        try {
            NodeDetail oldDetail = this.getHeader(detail.getNodePK());
            this.update(con, this.updateNodeDetailWith(oldDetail, detail));
        }
        catch (SQLException ex) {
            throw new NodeRuntimeException(ex);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private NodeDetail updateNodeDetailWith(NodeDetail nodeToUpdate, NodeDetail newState) {
        if (newState.getDescription() != null) {
            nodeToUpdate.setDescription(newState.getDescription());
        }
        if (newState.getName() != null) {
            nodeToUpdate.setName(newState.getName());
        }
        if (newState.getCreationDate() != null) {
            nodeToUpdate.setCreationDate(newState.getCreationDate());
        }
        if (newState.getCreatorId() != null) {
            nodeToUpdate.setCreatorId(newState.getCreatorId());
        }
        if (newState.getModelId() != null) {
            nodeToUpdate.setModelId(newState.getModelId());
        }
        if (newState.getStatus() != null) {
            nodeToUpdate.setStatus(newState.getStatus());
        }
        if (newState.getNodeType() != null) {
            nodeToUpdate.setNodeType(newState.getNodeType());
        }
        if ("file_link".equals(newState.getNodeType())) {
            nodeToUpdate.setPath(newState.getPath());
        }
        if (newState.getFatherPK() != null && StringUtil.isInteger((String)newState.getFatherPK().getId()) && StringUtil.isDefined((String)newState.getFatherPK().getInstanceId())) {
            nodeToUpdate.setFatherPK(newState.getFatherPK());
        }
        if (StringUtil.isDefined((String)newState.getPath())) {
            nodeToUpdate.setPath(newState.getPath());
        }
        nodeToUpdate.setRightsDependsOn(newState.getRightsDependsOn());
        nodeToUpdate.setOrder(newState.getOrder());
        nodeToUpdate.setLanguage(newState.getLanguage());
        return nodeToUpdate;
    }

    private void update(Connection con, NodeDetail detail) throws SQLException {
        this.nodeDAO.storeRow(con, detail);
    }

    private void createTranslations(Connection con, NodeDetail node) throws SQLException {
        if (node.getTranslations() != null) {
            for (NodeI18NDetail translation : node.getTranslations().values()) {
                if (node.getLanguage() == null || node.getLanguage().equals(translation.getLanguage())) continue;
                translation.setObjectId(node.getNodePK().getId());
                NodeI18NDAO.saveTranslation(con, translation);
            }
        }
    }

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new NodeRuntimeException(e);
        }
    }

    @Override
    public boolean isSameNameSameLevelOnCreation(NodeDetail nd) {
        Connection con = this.getConnection();
        try {
            boolean bl = this.nodeDAO.isSameNameSameLevelOnCreation(con, nd);
            return bl;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public boolean isSameNameSameLevelOnUpdate(NodeDetail nd) {
        Connection con = this.getConnection();
        try {
            boolean bl = this.nodeDAO.isSameNameSameLevelOnUpdate(con, nd);
            return bl;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<NodePK> getChildrenPKs(NodePK nodePK) {
        Connection con = this.getConnection();
        try {
            Collection<NodePK> collection = this.nodeDAO.getChildrenPKs(con, nodePK);
            return collection;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<NodePK> getDescendantPKs(NodePK nodePK) {
        Connection con = this.getConnection();
        try {
            Collection<NodePK> collection = this.nodeDAO.getDescendantPKs(con, nodePK);
            return collection;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<NodeDetail> getDescendantDetails(NodePK nodePK) {
        Connection con = this.getConnection();
        try {
            List<NodeDetail> list = this.nodeDAO.getDescendantDetails(con, nodePK);
            return list;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<NodeDetail> getDescendantDetails(NodeDetail node) {
        Connection con = this.getConnection();
        try {
            List<NodeDetail> list = this.nodeDAO.getDescendantDetails(con, node);
            return list;
        }
        catch (SQLException re) {
            throw new NodeRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void processWysiwyg(NodePK nodePK) {
        NodeDetail nodeDetail = this.getHeader(nodePK);
        this.createIndex(nodeDetail);
    }

    @Override
    @Transactional
    public void updateRightsDependency(NodeDetail nodeDetail) {
        this.updateNodeDetail(nodeDetail);
        this.spreadRightsDependency(nodeDetail, nodeDetail.getRightsDependsOn());
    }

    private void spreadRightsDependency(NodeDetail currentNode, String rightsDependsOn) {
        Collection<NodeDetail> children = this.getChildrenDetails(currentNode.getNodePK());
        for (NodeDetail child : children) {
            if (child.haveLocalRights()) continue;
            child.setRightsDependsOn(rightsDependsOn);
            this.updateNodeDetail(child);
            this.spreadRightsDependency(child, rightsDependsOn);
        }
    }

    @Override
    public void sortNodes(List<NodePK> nodePKs) {
        Connection con = this.getConnection();
        try {
            this.nodeDAO.sortNodes(con, nodePKs);
        }
        catch (SQLException e) {
            throw new NodeRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void createIndex(NodeDetail nodeDetail) {
        this.createIndex(nodeDetail, true);
    }

    private void createIndex(NodePK pk) {
        NodeDetail node = this.getDetail(pk);
        this.createIndex(node);
    }

    private void createIndex(NodeDetail nodeDetail, boolean processWysiwygContent) {
        UserDetail ud;
        String userId;
        Objects.requireNonNull(nodeDetail);
        FullIndexEntry indexEntry = this.getFullIndexEntry(nodeDetail, processWysiwygContent);
        indexEntry.setCreationDate(nodeDetail.getCreationDate());
        if (nodeDetail.getCreatorId() != null) {
            userId = nodeDetail.getCreatorId();
            indexEntry.setCreationUser(userId);
        } else {
            NodeDetail node = this.getHeader(nodeDetail.getNodePK());
            indexEntry.setCreationDate(node.getCreationDate());
            userId = node.getCreatorId();
            indexEntry.setCreationUser(userId);
        }
        if (nodeSettings.getString("indexAuthorName").equals("true") && (ud = UserDetail.getById(userId)) != null) {
            indexEntry.addTextContent(ud.getDisplayedName());
        }
        IndexEngineProxy.addIndexEntry(indexEntry);
    }

    private FullIndexEntry getFullIndexEntry(NodeDetail nodeDetail, boolean processWysiwygContent) {
        FullIndexEntry indexEntry = new FullIndexEntry(new IndexEntryKey(nodeDetail.getNodePK().getComponentName(), "Node", nodeDetail.getNodePK().getId()));
        Collection<String> languages = nodeDetail.getLanguages();
        languages.forEach(l -> {
            NodeI18NDetail translation = (NodeI18NDetail)nodeDetail.getTranslations().get(l);
            indexEntry.setTitle(translation.getName(), (String)l);
            indexEntry.setPreview(translation.getDescription(), (String)l);
            if (processWysiwygContent) {
                this.updateIndexEntryWithWysiwygContent(indexEntry, nodeDetail.getNodePK(), (String)l);
            }
        });
        return indexEntry;
    }

    private void updateIndexEntryWithWysiwygContent(FullIndexEntry indexEntry, NodePK nodePK, String language) {
        try {
            String wysiwygContent;
            if (nodePK != null && (wysiwygContent = WysiwygController.load(nodePK.getComponentName(), "Node_" + nodePK.getId(), language)) != null) {
                indexEntry.addTextContent(wysiwygContent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void deleteIndex(NodePK pk) {
        IndexEntryKey indexEntry = new IndexEntryKey(pk.getComponentName(), "Node", pk.getId());
        IndexEngineProxy.removeIndexEntry(indexEntry);
    }
}

