/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.converter.openoffice;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UnknownFormatConversionException;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.LocalConverter;
import org.silverpeas.core.contribution.converter.DocumentFormat;
import org.silverpeas.core.contribution.converter.DocumentFormatConversion;
import org.silverpeas.core.contribution.converter.DocumentFormatConversionException;
import org.silverpeas.core.contribution.converter.DocumentFormatException;
import org.silverpeas.core.contribution.converter.openoffice.OpenOfficeService;
import org.silverpeas.core.contribution.converter.option.FilterOption;
import org.silverpeas.core.util.file.FileRepositoryManager;

public abstract class OpenOfficeConverter
implements DocumentFormatConversion {
    @Inject
    private OpenOfficeService service;

    public abstract boolean isDocumentSupported(File var1);

    @Override
    public File convert(File source, DocumentFormat inFormat, FilterOption<?> ... options) {
        String fileName = FilenameUtils.getBaseName((String)source.getName()) + "." + inFormat.name();
        File destination = new File(FileRepositoryManager.getTemporaryPath() + fileName);
        return this.convert(source, destination, inFormat, options);
    }

    @Override
    public File convert(File source, File destination, DocumentFormat outFormat, FilterOption<?> ... options) {
        if (this.isNotFormatSupported(outFormat)) {
            throw new DocumentFormatException("The conversion of the file to the format " + outFormat.toString() + " isn't supported");
        }
        if (!this.isDocumentSupported(source)) {
            throw new DocumentFormatException("The format of the file " + source.getName() + " isn't supported by this converter");
        }
        try {
            DocumentConverter converter = this.getDocumentConverter(options);
            converter.convert(source).to(destination).as(this.documentFormat(outFormat)).execute();
        }
        catch (Exception e) {
            throw new DocumentFormatConversionException(e.getMessage(), e);
        }
        return destination;
    }

    @Override
    public void convert(InputStream source, DocumentFormat inFormat, OutputStream destination, DocumentFormat outFormat, FilterOption<?> ... options) {
        if (this.isNotFormatSupported(outFormat)) {
            throw new DocumentFormatException("The conversion of the stream to the format " + outFormat.toString() + " isn't supported");
        }
        try {
            DocumentConverter converter = this.getDocumentConverter(options);
            converter.convert(source).as(this.documentFormat(inFormat)).to(destination).as(this.documentFormat(outFormat)).execute();
        }
        catch (Exception e) {
            throw new DocumentFormatConversionException(e.getMessage(), e);
        }
    }

    private boolean isNotFormatSupported(DocumentFormat format) {
        return !Arrays.asList(this.getSupportedFormats()).contains((Object)format);
    }

    private DocumentConverter getDocumentConverter(FilterOption<?> ... options) {
        OfficeManager manager = this.service.getOfficeManager();
        LocalConverter.Builder builder = (LocalConverter.Builder)LocalConverter.builder().officeManager(manager);
        if (options.length > 0) {
            HashMap filterData = new HashMap();
            HashMap customProperties = new HashMap();
            for (FilterOption<?> option : options) {
                filterData.put(option.getName(), option.getValue());
            }
            customProperties.put("FilterData", filterData);
            builder.storeProperties(customProperties);
        }
        return builder.build();
    }

    private org.jodconverter.core.document.DocumentFormat documentFormat(DocumentFormat format) {
        String mimeType = format.getMimeType();
        org.jodconverter.core.document.DocumentFormat docFormat = DefaultDocumentFormatRegistry.getFormatByMediaType((String)mimeType);
        if (docFormat == null) {
            if ("application/rtf".equals(mimeType)) {
                mimeType = mimeType.replaceFirst("application", "text");
            }
            docFormat = DefaultDocumentFormatRegistry.getFormatByMediaType((String)mimeType);
        }
        if (docFormat == null) {
            throw new UnknownFormatConversionException("Unknown document format for MIME-TYPE: " + format.getMimeType());
        }
        return docFormat;
    }
}

