/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.displayers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.owasp.encoder.Encode;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.contribution.content.form.Util;
import org.silverpeas.core.contribution.content.form.displayers.AbstractFieldDisplayer;
import org.silverpeas.core.contribution.content.form.field.AccessPathField;

public class AccessPathFieldDisplayer
extends AbstractFieldDisplayer<AccessPathField> {
    public String[] getManagedTypes() {
        return new String[]{"accessPath"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext pagesContext) throws IOException {
    }

    @Override
    public void display(PrintWriter out, AccessPathField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        String value = null;
        StringBuilder html2 = new StringBuilder();
        String fieldName = template.getFieldName();
        String currentAccessPath = "";
        if ("accessPath".equals(field.getTypeName())) {
            currentAccessPath = field.getAccessPath(pagesContext.getComponentId(), pagesContext.getNodeId(), pagesContext.getContentLanguage());
        }
        if (!field.isNull()) {
            value = field.getValue(pagesContext.getLanguage());
        }
        html2.append("<input id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\" type=\"text\" size=\"80\"");
        if (value != null) {
            html2.append(" value=\"").append(Encode.forHtml((String)value)).append("\"");
        } else {
            html2.append(" value=\"").append(Encode.forHtml((String)currentAccessPath)).append("\"");
        }
        if (template.isDisabled() || template.isReadOnly()) {
            html2.append(" disabled=\"disabled\"");
        }
        html2.append("/>\n");
        if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pagesContext.useMandatory()) {
            html2.append(Util.getMandatorySnippet());
        }
        out.println(html2);
    }

    @Override
    public List<String> update(String newValue, AccessPathField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if (!"accessPath".equals(field.getTypeName())) {
            throw new FormException("Incorrect field type '{0}', expected; {0}", "accessPath");
        }
        if (!field.acceptValue(newValue, pagesContext.getLanguage())) {
            throw new FormException("Incorrect field value type. Expected {0}", "accessPath");
        }
        field.setValue(newValue, pagesContext.getLanguage());
        return new ArrayList<String>();
    }

    @Override
    public boolean isDisplayedMandatory() {
        return false;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 1;
    }
}

