/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;
import org.silverpeas.core.backgroundprocess.BackgroundProcessTask;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class CalendarIntegrityProcessor
implements Initialization {
    public void init() {
        BackgroundProcessTask.push((AbstractBackgroundProcessRequest)new DeletedUserCalendarCleaner());
    }

    private static class DeletedUserCalendarCleaner
    extends AbstractBackgroundProcessRequest {
        private static final String COMPONENT_INSTANCE_FROM_USER = "CONCAT('userCalendar' , CONCAT(CAST(u.id AS VARCHAR(20)), '_PCI'))";

        private DeletedUserCalendarCleaner() {
        }

        protected void process() {
            try {
                ListSlice componentInstanceIdsToClear = JdbcSqlQuery.select((String)"distinct c.instanceid").from(new String[]{"st_user u"}).join("sb_cal_calendar c").on("c.instanceid = CONCAT('userCalendar' , CONCAT(CAST(u.id AS VARCHAR(20)), '_PCI'))", new Object[0]).where("u.state = ?", new Object[]{UserState.DELETED.name()}).execute(r -> r.getString(1));
                if (!componentInstanceIdsToClear.isEmpty()) {
                    Transaction.performInOne(() -> DeletedUserCalendarCleaner.lambda$process$1((List)componentInstanceIdsToClear));
                }
            }
            catch (SQLException e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            }
        }

        private static /* synthetic */ Object lambda$process$1(List componentInstanceIdsToClear) throws Exception {
            Calendar.getByComponentInstanceIds((Collection)componentInstanceIdsToClear).forEach(Calendar::delete);
            return null;
        }
    }
}

