/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.domain.DomainDriverManager;
import org.silverpeas.core.admin.domain.synchro.SynchroDomainReport;
import org.silverpeas.core.admin.persistence.GroupUserRoleRow;
import org.silverpeas.core.admin.persistence.GroupUserRoleTable;
import org.silverpeas.core.admin.persistence.OrganizationSchema;
import org.silverpeas.core.admin.persistence.SpaceUserRoleRow;
import org.silverpeas.core.admin.persistence.SpaceUserRoleTable;
import org.silverpeas.core.admin.persistence.UserRoleRow;
import org.silverpeas.core.admin.persistence.UserRoleTable;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.GroupAlreadyExistsAdminException;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.dao.GroupDAO;
import org.silverpeas.core.admin.user.dao.UserDAO;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.GroupsSearchCriteria;
import org.silverpeas.core.admin.user.model.UserDetailsSearchCriteria;
import org.silverpeas.core.admin.user.notification.GroupEventNotifier;
import org.silverpeas.core.admin.user.notification.GroupUserLink;
import org.silverpeas.core.admin.user.notification.GroupUserLinkEventNotifier;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Singleton
@Transactional(value=Transactional.TxType.MANDATORY)
public class GroupManager {
    public static final String GROUP = "group";
    public static final String GROUP_MANAGER_GET_GROUPS_OF_DOMAIN = "GroupManager.getGroupsOfDomain()";
    public static final String GROUP_MANAGER_ADD_GROUP = "GroupManager.addGroup()";
    public static final String GROUP_MANAGER_UPDATE_GROUP = "GroupManager.updateGroup()";
    public static final String IN_GROUP = "in group ";
    public static final String GROUP_MANAGER_DELETE_GROUP = "GroupManager.deleteGroup()";
    private static final String GROUP_MANAGER_REMOVE_GROUP = "GroupManager.removeGroup()";
    public static final String IN_SILVERPEAS_MESSAGE = " dans la base";
    private static final String GROUPMANAGER_SYNCHRO_REPORT = "GroupManager";
    private static final String GROUP_TABLE_RESTORE_GROUP = "GroupTable.restoreGroup()";
    private static final String AWAITING_DELETION_MESSAGE = "En attente de suppression du groupe ";
    private static final String REMOVING_MESSAGE = "Suppression de ";
    private static final String ID_PART = " (ID=";
    private static final String SPECIFIC_ID = "(specificId:";
    @Inject
    private GroupDAO groupDao;
    @Inject
    private UserDAO userDao;
    @Inject
    private GroupEventNotifier groupNotifier;
    @Inject
    private GroupUserLinkEventNotifier linkNotifier;
    @Inject
    private DomainDriverManager domainDriverManager;

    protected GroupManager() {
    }

    public static GroupManager get() {
        return (GroupManager)ServiceProvider.getService(GroupManager.class, (Annotation[])new Annotation[0]);
    }

    public SilverpeasList<GroupDetail> getGroupsMatchingCriteria(GroupsSearchCriteria criteria, boolean orderedByType) throws AdminException {
        SilverpeasList<GroupDetail> silverpeasList;
        block11: {
            Connection connection = DBUtil.openConnection();
            try {
                GroupCriteriaFilter filter = new GroupCriteriaFilter(connection, criteria, orderedByType, this.groupDao);
                SilverpeasList<GroupDetail> groups = filter.getFilteredValidGroups();
                String[] domainIdConstraint = new String[]{};
                if (criteria.isCriterionOnDomainIdSet()) {
                    for (String domainId : criteria.getCriterionOnDomainIds()) {
                        if ("-1".equals(domainId)) continue;
                        domainIdConstraint = new String[]{domainId};
                        break;
                    }
                }
                for (GroupDetail group : groups) {
                    List<String> groupIds = filter.getAllValidSubGroups(group.getId()).stream().map(GroupDetail::getId).collect(Collectors.toList());
                    groupIds.add(group.getId());
                    UserState[] criterionOnUserStatesToExclude = criteria.getCriterionOnUserStatesToExclude();
                    int userCount = this.userDao.getUserCountByCriteria(connection, new UserDetailsSearchCriteria().onDomainIds(domainIdConstraint).onGroupIds(groupIds.toArray(new String[0])).onUserStatesToExclude(criterionOnUserStatesToExclude));
                    group.setTotalNbUsers(userCount);
                }
                silverpeasList = groups;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException("Fail to search groups matching criteria", e);
                }
            }
            connection.close();
        }
        return silverpeasList;
    }

    public int getTotalUserCountInGroup(String domainId, String groupId) throws AdminException {
        Connection connection = null;
        try {
            connection = DBUtil.openConnection();
            List<String> groupIds = this.getAllSubGroupIdsRecursively(groupId);
            groupIds.add(groupId);
            int n = this.userDao.getUserCountByCriteria(connection, new UserDetailsSearchCriteria().onDomainIds(domainId).onGroupIds(groupIds.toArray(new String[0])).onUserStatesToExclude(UserState.REMOVED));
            return n;
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    public void addUserInGroup(String sUserId, String sGroupId) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            this.groupDao.addUserInGroup(connection, sUserId, sGroupId);
            this.notifyUserInGroup(ResourceEvent.Type.CREATION, sUserId, sGroupId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)("user " + sUserId), (Object)(IN_GROUP + sGroupId)), e);
        }
    }

    public void addUsersInGroup(List<String> userIds, String groupId) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            this.groupDao.addUsersInGroup(connection, userIds, groupId);
            userIds.forEach(u -> this.notifyUserInGroup(ResourceEvent.Type.CREATION, (String)u, groupId));
        }
        catch (SQLException e) {
            throw new AdminException(e.getMessage(), e);
        }
    }

    public void removeUserFromGroup(String sUserId, String sGroupId) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            SynchroDomainReport.debug("GroupManager.removeUserFromGroup()", "Retrait de l'utilisateur d'ID " + sUserId + " du groupe d'ID " + sGroupId);
            this.groupDao.deleteUserInGroup(connection, sUserId, sGroupId);
            this.notifyUserInGroup(ResourceEvent.Type.DELETION, sUserId, sGroupId);
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)("user " + sUserId), (Object)(IN_GROUP + sGroupId)), e);
        }
    }

    public void removeUsersFromGroup(List<String> userIds, String groupId) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            for (String userId : userIds) {
                this.groupDao.deleteUserInGroup(connection, userId, groupId);
                this.notifyUserInGroup(ResourceEvent.Type.DELETION, userId, groupId);
            }
        }
        catch (SQLException e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)("users " + String.join((CharSequence)"n", userIds)), (Object)(IN_GROUP + groupId)), e);
        }
    }

    public List<String> getDirectGroupIdsInSpaceRole(String spaceRoleId, boolean includeRemoved) throws AdminException {
        List<String> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.groupDao.getDirectGroupIdsBySpaceUserRole(connection, spaceRoleId, includeRemoved);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"groups in space role", (Object)spaceRoleId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<GroupDetail> getDirectGroupsOfUser(String userId) throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.groupDao.getDirectGroupsOfUser(connection, userId, false);
                list = this.setDirectUsersOfGroups(groups);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"direct groups of user", (Object)userId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<GroupDetail> getAllDirectGroupsOfUser(String sUserId) throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.groupDao.getDirectGroupsOfUser(connection, sUserId, true);
                list = this.setDirectUsersOfGroups(groups);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"direct groups of user", (Object)sUserId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<String> getAllGroupsOfUser(String userId) throws AdminException {
        HashSet<String> allGroupsOfUser = new HashSet<String>();
        List<GroupDetail> directGroups = this.getDirectGroupsOfUser(userId);
        for (GroupDetail group : directGroups) {
            if (group == null) continue;
            allGroupsOfUser.add(group.getId());
            while (group != null && StringUtil.isDefined((String)group.getSuperGroupId())) {
                if ((group = this.getGroupDetail(group.getSuperGroupId())) == null) continue;
                allGroupsOfUser.add(group.getId());
            }
        }
        return new ArrayList<String>(allGroupsOfUser);
    }

    public String getGroupIdBySpecificIdAndDomainId(String sSpecificId, String sDomainId) throws AdminException {
        String string;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                GroupDetail gr = this.groupDao.getGroupBySpecificId(connection, sDomainId, sSpecificId);
                string = gr.getId();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"groups by specific id and domain", (Object)(sSpecificId + "/" + sDomainId)), e);
                }
            }
            connection.close();
        }
        return string;
    }

    public List<GroupDetail> getAllGroups() throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.groupDao.getAllGroups(connection);
                list = this.setDirectUsersOfGroups(groups);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all", (Object)"groups"), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<GroupDetail> getAllRootGroups() throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.groupDao.getAllRootGroups(connection);
                list = this.setDirectUsersOfGroups(groups);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all root groups", (Object)""), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<GroupDetail> getSubGroups(String groupId) throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.groupDao.getDirectSubGroups(connection, groupId, false);
                list = this.setDirectUsersOfGroups(groups);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all subgroups of group", (Object)groupId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<GroupDetail> getRecursivelySubGroups(String groupId) throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.getRecursivelyValidSubGroups(connection, groupId);
                list = this.setDirectUsersOfGroups(groups);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"recursively all subgroups of group", (Object)groupId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    private List<GroupDetail> getRecursivelyValidSubGroups(Connection connection, String groupId) throws SQLException {
        ArrayList<GroupDetail> subGroupsFlatTree = new ArrayList<GroupDetail>();
        List<GroupDetail> groups = this.groupDao.getDirectSubGroups(connection, groupId, false);
        for (GroupDetail group : groups) {
            subGroupsFlatTree.add(group);
            subGroupsFlatTree.addAll(this.getRecursivelyValidSubGroups(connection, group.getId()));
        }
        return subGroupsFlatTree;
    }

    public List<String> getPathToGroup(String groupId) throws AdminException {
        ArrayList<String> arrayList;
        block9: {
            Connection connection = DBUtil.openConnection();
            try {
                ArrayList<String> path = new ArrayList<String>();
                GroupDetail superGroup = this.groupDao.getSuperGroup(connection, groupId);
                while (superGroup != null) {
                    path.add(0, superGroup.getId());
                    superGroup = this.groupDao.getSuperGroup(connection, superGroup.getId());
                }
                arrayList = path;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"path to group", (Object)groupId), e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    public boolean isGroupExist(String sName) throws AdminException {
        boolean bl;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                bl = this.groupDao.isGroupByNameExists(connection, sName);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"all groups matching name", (Object)sName), e);
                }
            }
            connection.close();
        }
        return bl;
    }

    private GroupDetail getGroupDetail(String groupId) throws AdminException {
        GroupDetail groupDetail;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                groupDetail = this.groupDao.getGroup(connection, groupId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)GROUP, (Object)groupId), e);
                }
            }
            connection.close();
        }
        return groupDetail;
    }

    public GroupDetail getGroup(String groupId) throws AdminException {
        GroupDetail group = this.getGroupDetail(groupId);
        if (group != null) {
            try {
                this.setDirectUsersOfGroup(group);
            }
            catch (SQLException e) {
                throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"failure getting direct users of group", (Object)groupId), e);
            }
        }
        return group;
    }

    public List<String> getAllSubGroupIdsRecursively(String superGroupId) throws AdminException {
        List<String> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                list = this.getIdsOfValidSubGroup(con, superGroupId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"recursively all valid subgroups of group", (Object)superGroupId), e);
                }
            }
            con.close();
        }
        return list;
    }

    private List<String> getIdsOfValidSubGroup(Connection con, String groupId) throws SQLException {
        ArrayList<String> groupIds = new ArrayList<String>();
        List<GroupDetail> groups = this.groupDao.getDirectSubGroups(con, groupId, false);
        for (GroupDetail group : groups) {
            groupIds.add(group.getId());
            groupIds.addAll(this.getIdsOfValidSubGroup(con, group.getId()));
        }
        return groupIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupDetail getGroupByNameInDomain(String sGroupName, String sDomainFatherId) throws AdminException {
        try (Connection connection = DBUtil.openConnection();){
            GroupDetail group = this.domainDriverManager.getGroupByNameInDomain(sGroupName, sDomainFatherId);
            if (group != null) {
                String specificId = group.getSpecificId();
                GroupDetail gr = this.groupDao.getGroupBySpecificId(connection, sDomainFatherId, specificId);
                if (gr == null) {
                    GroupDetail groupDetail2 = null;
                    return groupDetail2;
                }
                group.setId(gr.getId());
                this.setDirectUsersOfGroup(group);
            }
            GroupDetail groupDetail = group;
            return groupDetail;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"group by name", (Object)sGroupName), e);
        }
    }

    public GroupDetail[] getRootGroupsOfDomain(String sDomainId) throws AdminException {
        GroupDetail[] groupDetailArray;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.groupDao.getAllRootGroupsByDomainId(connection, sDomainId);
                this.setDirectUsersOfGroups(groups);
                groupDetailArray = groups.toArray(new GroupDetail[0]);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"root groups in domain", (Object)sDomainId), e);
                }
            }
            connection.close();
        }
        return groupDetailArray;
    }

    public List<GroupDetail> getSynchronizedGroups() throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                List<GroupDetail> groups = this.groupDao.getSynchronizedGroups(connection);
                list = this.setDirectUsersOfGroups(groups).stream().filter(GroupDetail::isSynchronized).collect(Collectors.toList());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"synchronized groups", (Object)""), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<GroupDetail> getGroupsOfDomain(String domainId) throws AdminException {
        List<GroupDetail> list;
        block9: {
            Connection connection = DBUtil.openConnection();
            try {
                SynchroDomainReport.debug(GROUP_MANAGER_GET_GROUPS_OF_DOMAIN, "Recherche des groupes du domaine dans la base...");
                List<GroupDetail> groups = this.groupDao.getAllGroupsByDomainId(connection, domainId, true);
                this.setDirectUsersOfGroups(groups);
                for (int i = 0; i < groups.size(); ++i) {
                    GroupDetail group = groups.get(i);
                    SynchroDomainReport.debug(GROUP_MANAGER_GET_GROUPS_OF_DOMAIN, "Groupe trouv\u00e9 no : " + i + ", specificID : " + group.getSpecificId() + ", desc. : " + group.getDescription());
                }
                SynchroDomainReport.debug(GROUP_MANAGER_GET_GROUPS_OF_DOMAIN, "R\u00e9cup\u00e9ration de " + groups.size() + " groupes du domaine dans la base");
                list = groups;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"groups in domain", (Object)domainId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public List<String> getDirectGroupIdsInRole(String roleId, boolean includeRemoved) throws AdminException {
        List<String> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.groupDao.getDirectGroupIdsByUserRole(connection, roleId, includeRemoved);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"groups in profile ", (Object)roleId), e);
                }
            }
            connection.close();
        }
        return list;
    }

    public String addGroup(GroupDetail group, boolean onlyInSilverpeas, boolean indexation) throws AdminException {
        String string;
        block16: {
            if (group == null || !StringUtil.isDefined((String)group.getName())) {
                if (group != null) {
                    SynchroDomainReport.error(GROUP_MANAGER_ADD_GROUP, "Probl\u00e8me lors de l'ajout du groupe " + group.getSpecificId() + " dans la base, ce groupe n'a pas de nom", null);
                }
                return "";
            }
            Connection connection = DBUtil.openConnection();
            try {
                if (group.getDomainId() != null) {
                    this.checkGroupNotExists(group, connection);
                    if (!onlyInSilverpeas) {
                        String specificId = this.domainDriverManager.createGroup(group);
                        group.setSpecificId(specificId);
                    }
                }
                if (StringUtil.isDefined((String)group.getSuperGroupId())) {
                    SynchroDomainReport.debug(GROUP_MANAGER_ADD_GROUP, "Ajout du groupe " + group.getName() + " (p\u00e8re=" + this.getGroupDetail(group.getSuperGroupId()).getSpecificId() + ") dans la table ST_Group");
                } else {
                    SynchroDomainReport.debug(GROUP_MANAGER_ADD_GROUP, "Ajout du groupe " + group.getName() + " (groupe racine) dans la table ST_Group...");
                }
                String groupId = this.groupDao.addGroup(connection, group);
                group.setId(groupId);
                this.groupNotifier.notifyEventOn(ResourceEvent.Type.CREATION, (Serializable[])new Group[]{group});
                if (indexation) {
                    this.domainDriverManager.indexGroup(group);
                }
                SynchroDomainReport.debug(GROUP_MANAGER_ADD_GROUP, "Inclusion des utilisateurs directement associ\u00e9s au groupe " + group.getName() + " (table ST_Group_User_Rel)");
                String[] asUserIds = group.getUserIds();
                int nUserAdded = 0;
                for (String asUserId : asUserIds) {
                    if (!StringUtil.isDefined((String)asUserId)) continue;
                    this.groupDao.addUserInGroup(connection, asUserId, groupId);
                    ++nUserAdded;
                }
                SynchroDomainReport.info(GROUP_MANAGER_ADD_GROUP, nUserAdded + " utilisateurs ajout\u00e9s au groupe " + group.getName() + IN_SILVERPEAS_MESSAGE);
                string = groupId;
                if (connection == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    SynchroDomainReport.error(GROUP_MANAGER_ADD_GROUP, "probl\u00e8me lors de l'ajout du groupe " + group.getName() + " - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnAdding((String)GROUP, (Object)group.getName()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    private void checkGroupNotExists(GroupDetail group, Connection connection) throws SQLException, GroupAlreadyExistsAdminException {
        if (StringUtil.isDefined((String)group.getSpecificId()) && this.groupDao.getGroupBySpecificId(connection, group.getDomainId(), group.getSpecificId()) != null) {
            SynchroDomainReport.debug(GROUP_MANAGER_ADD_GROUP, "Le groupe (specificid=" + group.getSpecificId() + ", domainId=" + group.getDomainId() + ") existe d\u00e9j\u00e0 dans la table ST_Group...");
            throw new GroupAlreadyExistsAdminException(group);
        }
    }

    public List<GroupDetail> restoreGroup(GroupDetail group, boolean indexation) throws AdminException {
        List<GroupDetail> list;
        block9: {
            String restoreGroup = ".restoreGroup()";
            Connection connection = DBUtil.openConnection();
            try {
                SynchroDomainReport.info("GroupManager.restoreGroup()", "Restauration du groupe " + group.getSpecificId());
                List<GroupDetail> restoredGroups = this.restoreGroup(connection, group);
                if (indexation) {
                    restoredGroups.forEach(this.domainDriverManager::indexGroup);
                }
                list = restoredGroups;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error("GroupManager.restoreGroup()", "probl\u00e8me \u00e0 la restauration du groupe " + group.getName() + SPECIFIC_ID + group.getSpecificId() + ") - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnRestoring((String)GROUP, (Object)group.getId()), e);
                }
            }
            connection.close();
        }
        return list;
    }

    private List<GroupDetail> restoreGroup(Connection connection, GroupDetail group) throws SQLException {
        GroupDetail superGroup;
        ArrayList<GroupDetail> allRestoredGroups = new ArrayList<GroupDetail>();
        SynchroDomainReport.debug(GROUP_TABLE_RESTORE_GROUP, AWAITING_DELETION_MESSAGE + group.getName() + ID_PART + group.getId() + ")");
        this.groupDao.restoreGroup(connection, group).ifPresent(allRestoredGroups::add);
        String superGroupId = group.getSuperGroupId();
        if (StringUtil.isDefined((String)superGroupId) && (superGroup = this.groupDao.getGroup(connection, superGroupId)) != null && superGroup.isRemovedState()) {
            SynchroDomainReport.debug(GROUP_TABLE_RESTORE_GROUP, "En attente de suppression du groupe parent de " + group.getName() + IN_SILVERPEAS_MESSAGE);
            allRestoredGroups.addAll(this.restoreGroup(connection, superGroup));
        }
        return allRestoredGroups;
    }

    public List<GroupDetail> removeGroup(GroupDetail group, boolean indexation) throws AdminException {
        List<GroupDetail> list;
        block9: {
            String removeGroup = ".removeGroup()";
            Connection connection = DBUtil.openConnection();
            try {
                SynchroDomainReport.debug(GROUP_MANAGER_REMOVE_GROUP, AWAITING_DELETION_MESSAGE + group.getSpecificId() + " de la base...");
                List<GroupDetail> removedGroups = this.removeGroup(connection, group);
                if (indexation) {
                    removedGroups.stream().map(GroupDetail::getId).forEach(this.domainDriverManager::unindexGroup);
                }
                list = removedGroups;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error(GROUP_MANAGER_REMOVE_GROUP, "probl\u00e8me \u00e0 la mise en attente de suppression du groupe " + group.getName() + SPECIFIC_ID + group.getSpecificId() + ") - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnRemoving((String)GROUP, (Object)group.getId()), e);
                }
            }
            connection.close();
        }
        return list;
    }

    private List<GroupDetail> removeGroup(Connection connection, GroupDetail group) throws SQLException {
        ArrayList<GroupDetail> allRemovedGroups = new ArrayList<GroupDetail>();
        SynchroDomainReport.debug(GROUP_MANAGER_REMOVE_GROUP, AWAITING_DELETION_MESSAGE + group.getName() + " dans la base...");
        List<GroupDetail> subgroups = this.groupDao.getDirectSubGroups(connection, group.getId(), true);
        if (!subgroups.isEmpty()) {
            SynchroDomainReport.debug(GROUP_MANAGER_REMOVE_GROUP, "En attente de suppression des groupes fils de " + group.getName() + IN_SILVERPEAS_MESSAGE);
            for (GroupDetail subgroup : subgroups) {
                allRemovedGroups.addAll(this.removeGroup(connection, subgroup));
            }
        }
        SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, AWAITING_DELETION_MESSAGE + group.getName() + ID_PART + group.getName() + ")");
        this.groupDao.removeGroup(connection, group).ifPresent(r -> allRemovedGroups.add(0, (GroupDetail)r));
        return allRemovedGroups;
    }

    public List<GroupDetail> deleteGroup(GroupDetail group, boolean onlyInSilverpeas) throws AdminException {
        List<GroupDetail> list;
        block9: {
            Connection connection = DBUtil.openConnection();
            try {
                if (group.getDomainId() != null && !onlyInSilverpeas) {
                    this.domainDriverManager.deleteGroup(group.getId());
                }
                List<GroupDetail> deletedGroups = this.deleteGroup(connection, group);
                deletedGroups.forEach(g -> {
                    this.groupNotifier.notifyEventOn(ResourceEvent.Type.DELETION, (Serializable[])new Group[]{group});
                    this.domainDriverManager.unindexGroup(g.getId());
                });
                list = deletedGroups;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    SynchroDomainReport.error(GROUP_MANAGER_DELETE_GROUP, "probl\u00e8me lors de la suppression du groupe " + group.getName() + " - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnDeleting((String)GROUP, (Object)group.getId()), e);
                }
            }
            connection.close();
        }
        return list;
    }

    private List<GroupDetail> deleteGroup(Connection connection, GroupDetail group) throws SQLException, AdminException {
        List<GroupDetail> subgroups;
        ArrayList<GroupDetail> allDeletedGroups = new ArrayList<GroupDetail>();
        allDeletedGroups.add(group);
        int groupId = this.idAsInt(group.getId());
        SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, "Suppression du groupe " + group.getName() + " dans la base...");
        UserRoleTable userRoleTable = OrganizationSchema.get().userRole();
        UserRoleRow[] roles = userRoleTable.getDirectUserRolesOfGroup(groupId);
        SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, REMOVING_MESSAGE + group.getName() + " des r\u00f4les dans la base");
        for (UserRoleRow role : roles) {
            userRoleTable.removeGroupFromUserRole(groupId, role.getId());
        }
        SpaceUserRoleTable spaceUserRoleTable = OrganizationSchema.get().spaceUserRole();
        SpaceUserRoleRow[] spaceRoles = spaceUserRoleTable.getDirectSpaceUserRolesOfGroup(groupId);
        SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, REMOVING_MESSAGE + group.getName() + " comme manager d'espace dans la base");
        for (SpaceUserRoleRow spaceRole : spaceRoles) {
            spaceUserRoleTable.removeGroupFromSpaceUserRole(groupId, spaceRole.getId());
        }
        GroupUserRoleTable groupUserRoleTable = OrganizationSchema.get().groupUserRole();
        GroupUserRoleRow[] groupRoles = groupUserRoleTable.getDirectGroupUserRolesOfGroup(groupId);
        SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, REMOVING_MESSAGE + group.getName() + " comme manager de groupe dans la base");
        for (GroupUserRoleRow groupRole : groupRoles) {
            groupUserRoleTable.removeGroupFromGroupUserRole(groupId, groupRole.id);
        }
        GroupUserRoleRow groupRole = groupUserRoleTable.getGroupUserRoleByGroupId(groupId);
        if (groupRole != null) {
            SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, REMOVING_MESSAGE + group.getName() + " des r\u00f4les de groupe dans la base");
            groupUserRoleTable.removeGroupUserRole(groupRole.id);
        }
        if (!(subgroups = this.groupDao.getDirectSubGroups(connection, group.getId(), true)).isEmpty()) {
            SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, "Suppression des groupes fils de " + group.getName() + IN_SILVERPEAS_MESSAGE);
            for (GroupDetail subgroup : subgroups) {
                allDeletedGroups.addAll(this.deleteGroup(connection, subgroup));
            }
        }
        List<String> userIds = this.userDao.getDirectUserIdsInGroup(connection, group.getId(), true);
        for (String userId : userIds) {
            this.removeUserFromGroup(userId, group.getId());
        }
        SynchroDomainReport.info(GROUP_MANAGER_DELETE_GROUP, REMOVING_MESSAGE + userIds.size() + " utilisateurs inclus directement dans le groupe " + group.getName() + IN_SILVERPEAS_MESSAGE);
        SynchroDomainReport.debug(GROUP_MANAGER_DELETE_GROUP, REMOVING_MESSAGE + group.getName() + ID_PART + group.getName() + ")");
        if (this.groupDao.deleteGroup(connection, group) == 0L) {
            allDeletedGroups.remove(0);
        }
        return allDeletedGroups;
    }

    public String updateGroup(GroupDetail group, boolean onlyInSilverpeas) throws AdminException {
        String string;
        block11: {
            if (group == null || !StringUtil.isDefined((String)group.getName()) || !StringUtil.isDefined((String)group.getId())) {
                if (group != null) {
                    SynchroDomainReport.error(GROUP_MANAGER_UPDATE_GROUP, "Probl\u00e8me lors de maj du groupe " + group.getSpecificId() + " dans la base, ce groupe n'a pas de nom", null);
                }
                return "";
            }
            Connection connection = DBUtil.openConnection();
            try {
                if (group.getDomainId() != null && !onlyInSilverpeas) {
                    this.domainDriverManager.updateGroup(group);
                }
                String sGroupId = group.getId();
                String strInfoSycnhro = group.getSuperGroupId() != null ? "Maj du groupe " + group.getName() + " (p\u00e8re=" + this.getGroupDetail(group.getSuperGroupId()).getSpecificId() + ") dans la base (table ST_Group)..." : "Maj du groupe " + group.getName() + " (groupe racine) dans la base (table ST_Group)...";
                SynchroDomainReport.debug(GROUP_MANAGER_UPDATE_GROUP, strInfoSycnhro);
                this.groupDao.updateGroup(connection, group);
                this.domainDriverManager.indexGroup(group);
                SynchroDomainReport.debug(GROUP_MANAGER_UPDATE_GROUP, "Maj \u00e9ventuelle des relations du groupe " + group.getName() + " avec les utilisateurs qui y sont directement inclus (tables ST_Group_User_Rel)");
                List<String> asOldUsersId = this.userDao.getDirectUserIdsInGroup(connection, sGroupId, false);
                List<String> asNewUsersId = Arrays.asList(group.getUserIds());
                long removedUsers = this.removeUsersNoMoreInGroup(connection, sGroupId, asOldUsersId, asNewUsersId);
                long addedUsers = this.addNewUsersInGroup(connection, sGroupId, asOldUsersId, asNewUsersId);
                SynchroDomainReport.info(GROUP_MANAGER_UPDATE_GROUP, "Groupe : " + group.getName() + ", ajout de " + addedUsers + " nouveaux utilisateurs, suppression de " + removedUsers + " utilisateurs");
                string = sGroupId;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SynchroDomainReport.error(GROUP_MANAGER_UPDATE_GROUP, "probl\u00e8me lors de la maj du groupe " + group.getName() + " - " + e.getMessage(), null);
                    throw new AdminException(SilverpeasExceptionMessages.failureOnUpdate((String)GROUP, (Object)group.getId()), e);
                }
            }
            connection.close();
        }
        return string;
    }

    private long addNewUsersInGroup(Connection connection, String sGroupId, List<String> asOldUsersId, List<String> asNewUsersId) throws SQLException {
        long addedUsers = 0L;
        for (String userId : asNewUsersId) {
            if (asOldUsersId.contains(userId)) continue;
            SynchroDomainReport.debug(GROUP_MANAGER_UPDATE_GROUP, "Ajout de l'utilisateur d'ID " + userId + " dans le groupe d'ID " + sGroupId);
            this.groupDao.addUserInGroup(connection, userId, sGroupId);
            this.notifyUserInGroup(ResourceEvent.Type.CREATION, userId, sGroupId);
            ++addedUsers;
        }
        return addedUsers;
    }

    private void notifyUserInGroup(ResourceEvent.Type typeOfOperation, String userId, String groupId) {
        GroupUserLink link = new GroupUserLink(groupId, userId);
        this.linkNotifier.notifyEventOn(typeOfOperation, new GroupUserLink[]{link});
    }

    private long removeUsersNoMoreInGroup(Connection connection, String sGroupId, List<String> asOldUsersId, List<String> asNewUsersId) throws SQLException {
        long removedUsers = 0L;
        for (String userId : asOldUsersId) {
            if (asNewUsersId.contains(userId)) continue;
            SynchroDomainReport.debug(GROUP_MANAGER_UPDATE_GROUP, "Suppression de l'utilisateur d'ID " + userId + " du groupe d'ID " + sGroupId);
            this.groupDao.deleteUserInGroup(connection, userId, sGroupId);
            this.notifyUserInGroup(ResourceEvent.Type.DELETION, userId, sGroupId);
            ++removedUsers;
        }
        return removedUsers;
    }

    public List<String> getManageableGroupIds(String userId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.openConnection();
            List<String> list = this.groupDao.getManageableGroupIds(con, userId, groupIds);
            return list;
        }
        catch (Exception e) {
            throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"groups manageable by user", (Object)userId), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    public List<GroupDetail> getRemovedGroupsOfDomains(String ... domainIds) throws AdminException {
        List<GroupDetail> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.groupDao.getRemovedGroups(connection, domainIds);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AdminException(SilverpeasExceptionMessages.failureOnGetting((String)"deleted groups in domains", (Object)String.join((CharSequence)", ", domainIds)), e);
                }
            }
            connection.close();
        }
        return list;
    }

    private List<GroupDetail> setDirectUsersOfGroups(List<GroupDetail> groups) throws SQLException {
        Map<String, List<String>> usersByGroup;
        try (Connection connection = DBUtil.openConnection();){
            usersByGroup = this.userDao.getDirectUserIdsByGroup(connection, groups.stream().map(GroupDetail::getId).collect(Collectors.toList()), false);
        }
        for (GroupDetail group : groups) {
            List<String> userIds = usersByGroup.getOrDefault(group.getId(), Collections.emptyList());
            group.setUserIds(userIds.toArray(new String[0]));
        }
        return groups;
    }

    private void setDirectUsersOfGroup(GroupDetail group) throws SQLException {
        this.setDirectUsersOfGroups(Collections.singletonList(group));
    }

    private int idAsInt(String id) {
        return StringUtil.asInt((String)id, (int)-1);
    }

    private static class GroupCriteriaFilter {
        private final Connection connection;
        private final GroupsSearchCriteria criteria;
        private final GroupDAO groupDao;
        private final String nameFilter;
        private final PaginationPage paginationPage;
        private final boolean childrenRequired;
        private final boolean mustMatchAllRoles;
        private final boolean logicalNameFiltering;
        private final boolean orderedByType;
        private final Map<String, List<GroupDetail>> subGroupsOfGroupsCache = new LinkedHashMap<String, List<GroupDetail>>();

        GroupCriteriaFilter(Connection connection, GroupsSearchCriteria criteria, boolean orderedByType, GroupDAO groupDao) {
            this.connection = connection;
            this.criteria = criteria;
            this.groupDao = groupDao;
            this.orderedByType = orderedByType;
            this.nameFilter = StringUtil.defaultStringIfNotDefined((String)criteria.getCriterionOnName()).replace('*', '%');
            this.childrenRequired = criteria.childrenRequired();
            this.logicalNameFiltering = this.childrenRequired && StringUtil.isDefined((String)this.nameFilter);
            this.mustMatchAllRoles = criteria.mustMatchAllRoles();
            if (this.childrenRequired || this.mustMatchAllRoles) {
                this.paginationPage = criteria.getCriterionOnPagination();
                criteria.clearPagination();
            } else {
                this.paginationPage = null;
            }
            if (this.logicalNameFiltering) {
                criteria.clearOnName();
            }
        }

        SilverpeasList<GroupDetail> getFilteredValidGroups() throws SQLException {
            Object groups = this.groupDao.getGroupsByCriteria(this.connection, this.criteria, this.orderedByType);
            Map<String, Set<String>> rolesByGroup = this.getRolesByGroup((List<GroupDetail>)groups);
            groups = this.addChildrenAndFilterOnName((List<GroupDetail>)groups, rolesByGroup);
            this.matchingAllRoles((List<GroupDetail>)groups, rolesByGroup);
            if (this.paginationPage != null) {
                groups = this.paginationPage.getPaginatedListFrom(groups);
            }
            return SilverpeasList.wrap(groups);
        }

        private void matchingAllRoles(List<GroupDetail> groups, Map<String, Set<String>> rolesByGroup) {
            if (rolesByGroup != null) {
                Iterator<GroupDetail> it = groups.iterator();
                int nbRoles = this.criteria.getCriterionOnRoleNames().length;
                while (it.hasNext()) {
                    GroupDetail group = it.next();
                    if (rolesByGroup.getOrDefault(group.getId(), Collections.emptySet()).size() == nbRoles) continue;
                    it.remove();
                }
            }
        }

        private List<GroupDetail> addChildrenAndFilterOnName(List<GroupDetail> groups, Map<String, Set<String>> rolesByGroup) {
            if (this.childrenRequired) {
                LinkedList<GroupDetail> allSubGroups = new LinkedList<GroupDetail>();
                Iterator<GroupDetail> it = groups.iterator();
                while (it.hasNext()) {
                    GroupDetail group = it.next();
                    if (this.logicalNameFiltering && !StringUtil.likeIgnoreCase((String)group.getName(), (String)this.nameFilter)) {
                        it.remove();
                    }
                    String groupId = group.getId();
                    List<GroupDetail> subGroups = this.getAllValidSubGroups(groupId);
                    if (this.logicalNameFiltering) {
                        subGroups.removeIf(g -> !StringUtil.likeIgnoreCase((String)g.getName(), (String)this.nameFilter));
                    }
                    if (rolesByGroup != null) {
                        subGroups.forEach(g -> {
                            Set roles = rolesByGroup.computeIfAbsent(g.getId(), k -> new HashSet());
                            roles.addAll((Collection)rolesByGroup.get(groupId));
                        });
                    }
                    allSubGroups.addAll(subGroups);
                }
                groups.addAll(allSubGroups);
                groups = groups.stream().distinct().sorted(Comparator.comparing(GroupDetail::getName)).collect(Collectors.toList());
            }
            return groups;
        }

        private Map<String, Set<String>> getRolesByGroup(List<GroupDetail> groups) throws SQLException {
            Map<String, Set<String>> rolesByGroup;
            if (this.mustMatchAllRoles && !groups.isEmpty()) {
                List<String> groupIds = groups.stream().map(GroupDetail::getId).collect(Collectors.toList());
                rolesByGroup = this.groupDao.getRolesByGroupsMappingWith(this.connection, groupIds, this.criteria.getCriterionOnProfileIds());
            } else {
                rolesByGroup = null;
            }
            return rolesByGroup;
        }

        List<GroupDetail> getAllValidSubGroups(String fromGroupId) {
            return this.getValidSubGroups(fromGroupId);
        }

        private List<GroupDetail> getValidSubGroups(String groupId) {
            ArrayList<GroupDetail> groups = new ArrayList<GroupDetail>();
            List<GroupDetail> directSubGroups = this.getDirectValidSubGroups(groupId);
            for (GroupDetail group : directSubGroups) {
                groups.add(group);
                groups.addAll(this.getValidSubGroups(group.getId()));
            }
            return groups;
        }

        private List<GroupDetail> getDirectValidSubGroups(String groupId) {
            return this.subGroupsOfGroupsCache.computeIfAbsent(groupId, i -> {
                try {
                    return this.groupDao.getDirectSubGroups(this.connection, groupId, false);
                }
                catch (SQLException e) {
                    throw new SilverpeasRuntimeException((Throwable)e);
                }
            });
        }
    }
}

