/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.SegmentWriterFactory;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.jetbrains.annotations.NotNull;

public class GCIncrement {
    @NotNull
    private final GCGeneration baseGeneration;
    @NotNull
    private final GCGeneration partialGeneration;
    @NotNull
    private final GCGeneration targetGeneration;

    public GCIncrement(@NotNull GCGeneration base, @NotNull GCGeneration partial, @NotNull GCGeneration target) {
        this.baseGeneration = base;
        this.partialGeneration = partial;
        this.targetGeneration = target;
    }

    @NotNull
    SegmentWriter createPartialWriter(@NotNull SegmentWriterFactory factory) {
        return factory.newSegmentWriter(this.partialGeneration);
    }

    @NotNull
    SegmentWriter createTargetWriter(@NotNull SegmentWriterFactory factory) {
        return factory.newSegmentWriter(this.targetGeneration);
    }

    boolean isFullyCompacted(GCGeneration generation) {
        return generation.compareWith(this.baseGeneration) > 0 && generation.equals(this.targetGeneration);
    }

    public String toString() {
        return "GCIncrement{\n  base:    " + this.baseGeneration + "\n  partial: " + this.partialGeneration + "\n  target:  " + this.targetGeneration + "\n}";
    }
}

