/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.dc.DcCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDateElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.draw.AbstractTextboxContainer;
import org.odftoolkit.simple.draw.Control;
import org.odftoolkit.simple.draw.ControlContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.draw.Textbox;
import org.odftoolkit.simple.draw.TextboxContainer;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.text.AbstractTextHyperlinkContainer;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.odftoolkit.simple.text.ParagraphStyleHandler;
import org.odftoolkit.simple.text.TextHyperlink;
import org.odftoolkit.simple.text.TextHyperlinkContainer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Paragraph
extends Component
implements TextboxContainer,
TextHyperlinkContainer,
ControlContainer {
    private TextPElement mParagraphElement;
    private TextHElement mHeadingElement;
    private Document mOwnerDocument;
    private ParagraphStyleHandler mStyleHandler;
    private TextboxContainerImpl mTextboxContainerImpl;
    private TextHyperlinkContainerImpl mHyperlinkContainerImpl;

    private Paragraph(TextParagraphElementBase paragraphElement) {
        if (paragraphElement instanceof TextPElement) {
            this.mParagraphElement = (TextPElement)paragraphElement;
            this.mHeadingElement = null;
        }
        if (paragraphElement instanceof TextHElement) {
            this.mHeadingElement = (TextHElement)paragraphElement;
            this.mParagraphElement = null;
        }
        this.mOwnerDocument = (Document)((OdfFileDom)paragraphElement.getOwnerDocument()).getDocument();
        this.mStyleHandler = new ParagraphStyleHandler(this);
    }

    public static Paragraph getInstanceof(TextParagraphElementBase paragraphElement) {
        if (paragraphElement == null) {
            return null;
        }
        Paragraph para = null;
        para = (Paragraph)Component.getComponentByElement((OdfElement)paragraphElement);
        if (para != null) {
            return para;
        }
        para = new Paragraph(paragraphElement);
        Component.registerComponent(para, (OdfElement)paragraphElement);
        return para;
    }

    public static Paragraph newParagraph(ParagraphContainer container) {
        Paragraph para = null;
        OdfElement parent = container.getParagraphContainerElement();
        OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
        TextPElement pEle = (TextPElement)ownerDom.newOdfElement(TextPElement.class);
        parent.appendChild((Node)pEle);
        para = new Paragraph((TextParagraphElementBase)pEle);
        Component.registerComponent(para, (OdfElement)pEle);
        return para;
    }

    public static Paragraph insertNewParagraphBefore(ParagraphContainer container, Node brother) {
        Paragraph para = null;
        OdfElement parent = container.getParagraphContainerElement();
        OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
        TextPElement pEle = (TextPElement)ownerDom.newOdfElement(TextPElement.class);
        parent.insertBefore((Node)pEle, brother);
        para = new Paragraph((TextParagraphElementBase)pEle);
        Component.registerComponent(para, (OdfElement)pEle);
        return para;
    }

    public void setTextContent(String content) {
        Paragraph.removeTextContentImpl((OdfElement)this.getOdfElement());
        Node lastNode = this.getOdfElement().getLastChild();
        if (lastNode != null && lastNode.getNodeName() != null && (lastNode.getNodeName().equals("text:a") || lastNode.getNodeName().equals("text:span"))) {
            if (content != null && !content.equals("")) {
                Paragraph.appendTextElements((OdfElement)((TextAElement)lastNode), content, true);
            }
        } else if (content != null && !content.equals("")) {
            Paragraph.appendTextElements((OdfElement)this.getOdfElement(), content, true);
        }
        Paragraph.removeEmptyHyperlink((OdfElement)this.getOdfElement());
    }

    static void removeEmptyHyperlink(OdfElement element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodename;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(nodename = node.getNodeName()).equals("text:a") || node.hasChildNodes()) continue;
            element.removeChild(node);
        }
    }

    public void removeTextContent() {
        Paragraph.removeTextContentImpl((OdfElement)this.getOdfElement());
        Paragraph.removeEmptyHyperlink((OdfElement)this.getOdfElement());
    }

    static void removeTextContentImpl(OdfElement ownerElement) {
        NodeList nodeList = ownerElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                ownerElement.removeChild(node);
                --i;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            String nodename = node.getNodeName();
            if (nodename.equals("text:s") || nodename.equals("text:tab") || nodename.equals("text:line-break")) {
                ownerElement.removeChild(node);
                --i;
                continue;
            }
            if (!nodename.equals("text:a")) continue;
            Paragraph.removeTextContentImpl((OdfElement)node);
        }
    }

    public String getTextContent() {
        return Paragraph.getTextContent((OdfElement)this.getOdfElement());
    }

    static String getTextContent(OdfElement ownerEle) {
        StringBuilder buffer = new StringBuilder();
        NodeList nodeList = ownerEle.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                buffer.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node instanceof TextSpanElement) {
                buffer.append(Paragraph.getTextContent((OdfElement)((TextSpanElement)node)));
                continue;
            }
            if (node.getNodeName().equals("text:s")) {
                Integer count = ((TextSElement)node).getTextCAttribute();
                for (int j = 0; j < (count != null ? count : 1); ++j) {
                    buffer.append(' ');
                }
                continue;
            }
            if (node.getNodeName().equals("text:tab")) {
                buffer.append('\t');
                continue;
            }
            if (node.getNodeName().equals("text:line-break")) {
                String lineseperator = System.getProperty("line.separator");
                buffer.append(lineseperator);
                continue;
            }
            if (!node.getNodeName().equals("text:a")) continue;
            buffer.append(TextHyperlink.getInstanceof((TextAElement)node).getTextContent());
        }
        return buffer.toString();
    }

    public void setTextContentNotCollapsed(String content) {
        this.removeTextContent();
        if (content != null && !content.equals("")) {
            Paragraph.appendTextElements((OdfElement)this.getOdfElement(), content, false);
        }
    }

    public void appendTextContent(String content) {
        this.appendTextContent(content, true);
    }

    public void appendTextContent(String content, boolean isStyleInherited) {
        boolean canInherited = false;
        Node lastNode = this.getOdfElement().getLastChild();
        if (lastNode != null && lastNode.getNodeName() != null && (lastNode.getNodeName().equals("text:a") || lastNode.getNodeName().equals("text:span"))) {
            canInherited = true;
        }
        if (isStyleInherited && canInherited) {
            if (content != null && !content.equals("")) {
                Paragraph.appendTextElements((OdfElement)lastNode, content, true);
            }
        } else if (content != null && !content.equals("")) {
            Paragraph.appendTextElements((OdfElement)this.getOdfElement(), content, true);
        }
    }

    public void appendTextContentNotCollapsed(String content) {
        Node lastNode = this.getOdfElement().getLastChild();
        boolean canInherited = false;
        if (lastNode != null && lastNode.getNodeName() != null && (lastNode.getNodeName().equals("text:a") || lastNode.getNodeName().equals("text:span"))) {
            canInherited = true;
        }
        if (canInherited) {
            if (content != null && !content.equals("")) {
                Paragraph.appendTextElements((OdfElement)lastNode, content, false);
            }
        } else if (content != null && !content.equals("")) {
            Paragraph.appendTextElements((OdfElement)this.getOdfElement(), content, false);
        }
    }

    public void setStyleName(String styleName) {
        this.mStyleHandler.getStyleElementForWrite().setStyleNameAttribute(styleName);
    }

    public String getStyleName() {
        OdfStyleBase style = this.getStyleHandler().getStyleElementForRead();
        if (style == null) {
            return "";
        }
        if (style instanceof OdfStyle) {
            return ((OdfStyle)style).getStyleNameAttribute();
        }
        return "";
    }

    @Override
    public Document getOwnerDocument() {
        return this.mOwnerDocument;
    }

    public void remove() {
        Component.unregisterComponent((OdfElement)this.getOdfElement());
        this.getOdfElement().getParentNode().removeChild((Node)this.getOdfElement());
        this.mParagraphElement = null;
        this.mHeadingElement = null;
        this.mOwnerDocument = null;
        this.mStyleHandler = null;
        this.mTextboxContainerImpl = null;
        this.mHyperlinkContainerImpl = null;
    }

    public ParagraphStyleHandler getStyleHandler() {
        if (this.mStyleHandler != null) {
            return this.mStyleHandler;
        }
        this.mStyleHandler = new ParagraphStyleHandler(this);
        return this.mStyleHandler;
    }

    public TextParagraphElementBase getOdfElement() {
        if (this.isHeading()) {
            return this.mHeadingElement;
        }
        return this.mParagraphElement;
    }

    public void addComment(String content, String creator) {
        OdfFileDom dom = (OdfFileDom)this.getOdfElement().getOwnerDocument();
        OfficeAnnotationElement annotationElement = (OfficeAnnotationElement)OdfXMLFactory.newOdfElement((OdfFileDom)dom, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.OFFICE, (String)"annotation"));
        this.getOdfElement().insertBefore((Node)annotationElement, this.getOdfElement().getFirstChild());
        DcCreatorElement dcCreatorElement = annotationElement.newDcCreatorElement();
        if (creator == null) {
            creator = System.getProperty("user.name");
        }
        dcCreatorElement.setTextContent(creator);
        String dcDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        DcDateElement dcDateElement = annotationElement.newDcDateElement();
        dcDateElement.setTextContent(dcDate);
        TextPElement notePElement = annotationElement.newTextPElement();
        TextSpanElement noteSpanElement = notePElement.newTextSpanElement();
        OdfOfficeAutomaticStyles styles = null;
        if (dom instanceof OdfContentDom) {
            styles = ((OdfContentDom)dom).getAutomaticStyles();
        } else if (dom instanceof OdfStylesDom) {
            styles = ((OdfStylesDom)dom).getAutomaticStyles();
        }
        OdfStyle textStyle = styles.newStyle(OdfStyleFamily.Text);
        StyleTextPropertiesElement styleTextPropertiesElement = textStyle.newStyleTextPropertiesElement(null);
        styleTextPropertiesElement.setStyleFontNameAttribute("Tahoma");
        styleTextPropertiesElement.setFoFontSizeAttribute("10pt");
        styleTextPropertiesElement.setStyleFontNameAsianAttribute("Lucida Sans Unicode");
        styleTextPropertiesElement.setStyleFontSizeAsianAttribute("12pt");
        noteSpanElement.setStyleName(textStyle.getStyleNameAttribute());
        noteSpanElement.setTextContent(content);
    }

    public boolean isHeading() {
        return this.mHeadingElement != null;
    }

    public int getHeadingLevel() {
        if (this.isHeading()) {
            return this.mHeadingElement.getTextOutlineLevelAttribute();
        }
        return 0;
    }

    public void applyHeading(boolean isHeading, int level) {
        if (isHeading) {
            if (!this.isHeading()) {
                OdfFileDom ownerDocument = (OdfFileDom)this.getOdfElement().getOwnerDocument();
                this.mHeadingElement = (TextHElement)ownerDocument.newOdfElement(TextHElement.class);
                for (Node firstChild = this.mParagraphElement.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
                    Node thisChild = firstChild;
                    this.mParagraphElement.removeChild(thisChild);
                    this.mHeadingElement.appendChild(thisChild);
                }
                this.mHeadingElement.setStyleName(this.mParagraphElement.getStyleName());
                Component.unregisterComponent((OdfElement)this.mParagraphElement);
                OdfElement parentOdfElement = (OdfElement)this.mParagraphElement.getParentNode();
                parentOdfElement.replaceChild((Node)this.mHeadingElement, (Node)this.mParagraphElement);
                this.mParagraphElement = null;
                Component.registerComponent(this, (OdfElement)this.mHeadingElement);
            }
            this.mHeadingElement.setTextOutlineLevelAttribute(Integer.valueOf(level));
        } else if (this.isHeading()) {
            OdfFileDom ownerDocument = (OdfFileDom)this.getOdfElement().getOwnerDocument();
            this.mParagraphElement = (TextPElement)ownerDocument.newOdfElement(TextPElement.class);
            for (Node firstChild = this.mHeadingElement.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
                Node thisChild = firstChild;
                this.mHeadingElement.removeChild(thisChild);
                this.mParagraphElement.appendChild(thisChild);
            }
            this.mParagraphElement.setStyleName(this.mHeadingElement.getStyleName());
            Component.unregisterComponent((OdfElement)this.mHeadingElement);
            OdfElement parentOdfElement = (OdfElement)this.mHeadingElement.getParentNode();
            parentOdfElement.replaceChild((Node)this.mParagraphElement, (Node)this.mHeadingElement);
            this.mHeadingElement = null;
            Component.registerComponent(this, (OdfElement)this.mParagraphElement);
        }
    }

    public void applyHeading() {
        this.applyHeading(true, 1);
    }

    public Font getFont() {
        return this.getStyleHandler().getFont(Document.ScriptType.WESTERN);
    }

    public void setFont(Font font) {
        this.getStyleHandler().setFont(font);
    }

    public StyleTypeDefinitions.HorizontalAlignmentType getHorizontalAlignment() {
        return this.getStyleHandler().getHorizontalAlignment();
    }

    public void setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType alignType) {
        this.getStyleHandler().setHorizontalAlignment(alignType);
    }

    @Override
    public Textbox addTextbox() {
        return this.getTextboxContainerImpl().addTextbox();
    }

    @Override
    public Iterator<Textbox> getTextboxIterator() {
        return this.getTextboxContainerImpl().getTextboxIterator();
    }

    @Override
    public boolean removeTextbox(Textbox box) {
        return this.getTextboxContainerImpl().removeTextbox(box);
    }

    @Override
    public OdfElement getFrameContainerElement() {
        return this.getTextboxContainerImpl().getFrameContainerElement();
    }

    @Override
    public Textbox addTextbox(FrameRectangle position) {
        return this.getTextboxContainerImpl().addTextbox(position);
    }

    @Override
    public Textbox getTextboxByName(String name) {
        return this.getTextboxContainerImpl().getTextboxByName(name);
    }

    @Override
    public List<Textbox> getTextboxByUsage(PresentationDocument.PresentationClass usage) {
        throw new UnsupportedOperationException("this method is not supported by paragraph.");
    }

    private TextboxContainerImpl getTextboxContainerImpl() {
        if (this.mTextboxContainerImpl == null) {
            this.mTextboxContainerImpl = new TextboxContainerImpl();
        }
        return this.mTextboxContainerImpl;
    }

    static void appendTextElements(OdfElement ownerElement, String content, boolean isWhitespaceCollapsed) {
        OdfFileDom ownerDocument = (OdfFileDom)ownerElement.getOwnerDocument();
        if (isWhitespaceCollapsed) {
            int i = 0;
            int length = content.length();
            String str = "";
            while (i < length) {
                char ch = content.charAt(i);
                if (ch == ' ') {
                    int j = 1;
                    ++i;
                    while (i < length && content.charAt(i) == ' ') {
                        ++j;
                        ++i;
                    }
                    if (j == 1) {
                        str = str + ' ';
                        continue;
                    }
                    str = str + ' ';
                    Text textnode = ownerDocument.createTextNode(str);
                    ownerElement.appendChild((Node)textnode);
                    str = "";
                    TextSElement spaceElement = (TextSElement)ownerDocument.newOdfElement(TextSElement.class);
                    ownerElement.appendChild((Node)spaceElement);
                    spaceElement.setTextCAttribute(Integer.valueOf(j - 1));
                    continue;
                }
                if (ch == '\n') {
                    if (str.length() > 0) {
                        Text textnode = ownerDocument.createTextNode(str);
                        ownerElement.appendChild((Node)textnode);
                        str = "";
                    }
                    TextLineBreakElement lineBreakElement = (TextLineBreakElement)ownerDocument.newOdfElement(TextLineBreakElement.class);
                    ownerElement.appendChild((Node)lineBreakElement);
                    ++i;
                    continue;
                }
                if (ch == '\t') {
                    if (str.length() > 0) {
                        Text textnode = ownerElement.getOwnerDocument().createTextNode(str);
                        ownerElement.appendChild((Node)textnode);
                        str = "";
                    }
                    TextTabElement tabElement = (TextTabElement)ownerDocument.newOdfElement(TextTabElement.class);
                    ownerElement.appendChild((Node)tabElement);
                    ++i;
                    continue;
                }
                if (ch == '\r') {
                    ++i;
                    continue;
                }
                str = str + ch;
                ++i;
            }
            if (str.length() > 0) {
                Text textnode = ownerDocument.createTextNode(str);
                ownerElement.appendChild((Node)textnode);
            }
        } else {
            Text textnode = ownerDocument.createTextNode(content);
            ownerElement.appendChild((Node)textnode);
        }
    }

    @Override
    public TextHyperlink applyHyperlink(URI linkto) {
        return this.getTextHyperlinkContainerImpl().applyHyperlink(linkto);
    }

    @Override
    public Iterator<TextHyperlink> getHyperlinkIterator() {
        return this.getTextHyperlinkContainerImpl().getHyperlinkIterator();
    }

    @Override
    public void removeHyperlinks() {
        this.getTextHyperlinkContainerImpl().removeHyperlinks();
    }

    @Override
    public TextHyperlink appendHyperlink(String text, URI linkto) {
        return this.getTextHyperlinkContainerImpl().appendHyperlink(text, linkto);
    }

    private TextHyperlinkContainerImpl getTextHyperlinkContainerImpl() {
        if (this.mHyperlinkContainerImpl == null) {
            this.mHyperlinkContainerImpl = new TextHyperlinkContainerImpl((OdfElement)this.getOdfElement());
        }
        return this.mHyperlinkContainerImpl;
    }

    @Override
    public Control createDrawControl() {
        return Control.newDrawControl(this);
    }

    @Override
    public OdfElement getDrawControlContainerElement() {
        return this.getOdfElement();
    }

    private class TextHyperlinkContainerImpl
    extends AbstractTextHyperlinkContainer {
        public TextHyperlinkContainerImpl(OdfElement parent) {
            super(parent);
        }
    }

    private class TextboxContainerImpl
    extends AbstractTextboxContainer {
        private TextboxContainerImpl() {
        }

        @Override
        public OdfElement getFrameContainerElement() {
            return Paragraph.this.getOdfElement();
        }
    }
}

