/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.util.Date;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.sharing.model.PublicationAccessControl;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.security.ShareableAccessControl;
import org.silverpeas.core.sharing.security.ShareablePublication;
import org.silverpeas.core.sharing.security.ShareableResource;

@Entity
@DiscriminatorValue(value="Publication")
public class PublicationTicket
extends Ticket {
    private static final long serialVersionUID = 6661700474412230957L;

    public PublicationTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Publication";
    }

    protected PublicationTicket() {
        this.sharedObjectType = "Publication";
    }

    @Override
    @Transient
    public ShareableAccessControl getAccessControl() {
        return new PublicationAccessControl(this);
    }

    @Transient
    public ShareableResource<PublicationDetail> getResource() {
        PublicationService publicationService = PublicationService.get();
        PublicationDetail publication = publicationService.getDetail(new PublicationPK(String.valueOf(this.getSharedObjectId()), this.getComponentId()));
        if (publication != null) {
            return new ShareablePublication(this.getToken(), publication);
        }
        return null;
    }
}

