/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.utils.SelectorTranslator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.BridgeAdd;
import org.wildfly.extension.messaging.activemq.ClusterConnectionDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.DivertAdd;
import org.wildfly.extension.messaging.activemq.GroupingHandlerDefinition;
import org.wildfly.extension.messaging.activemq.QueueDefinition;

public class ConfigurationHelper {
    static void addQueueConfigurations(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        List configs;
        if (model.hasDefined("queue")) {
            configs = configuration.getQueueConfigurations();
            for (Property prop : model.get("queue").asPropertyList()) {
                configs.add(ConfigurationHelper.createCoreQueueConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
        if (model.hasDefined("jms-queue")) {
            configs = configuration.getQueueConfigurations();
            for (Property prop : model.get("jms-queue").asPropertyList()) {
                configs.add(ConfigurationHelper.createJMSDestinationConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static CoreQueueConfiguration createCoreQueueConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String queueAddress = QueueDefinition.ADDRESS.resolveModelAttribute(context, model).asString();
        String filter = CommonAttributes.FILTER.resolveModelAttribute(context, model).asStringOrNull();
        String routing = QueueDefinition.DEFAULT_ROUTING_TYPE != null && !model.hasDefined(QueueDefinition.ROUTING_TYPE.getName()) ? RoutingType.valueOf((String)QueueDefinition.DEFAULT_ROUTING_TYPE.toUpperCase(Locale.ENGLISH)).toString() : QueueDefinition.ROUTING_TYPE.resolveModelAttribute(context, model).asString();
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        return new CoreQueueConfiguration().setAddress(queueAddress).setName(name).setFilterString(filter).setDurable(durable).setRoutingType(RoutingType.valueOf((String)routing));
    }

    static CoreQueueConfiguration createJMSDestinationConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String selector = CommonAttributes.SELECTOR.resolveModelAttribute(context, model).asStringOrNull();
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        String destinationAddress = "jms.queue." + name;
        return new CoreQueueConfiguration().setAddress(destinationAddress).setName(destinationAddress).setFilterString(SelectorTranslator.convertToActiveMQFilterString((String)selector)).setDurable(durable).setRoutingType(RoutingType.ANYCAST);
    }

    static void addDivertConfigurations(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("divert")) {
            List configs = configuration.getDivertConfigurations();
            for (Property prop : model.get("divert").asPropertyList()) {
                configs.add(DivertAdd.createDivertConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static Map<String, DiscoveryGroupConfiguration> addDiscoveryGroupConfigurations(OperationContext context, ModelNode model) throws OperationFailedException {
        HashMap<String, DiscoveryGroupConfiguration> configs = new HashMap<String, DiscoveryGroupConfiguration>();
        if (model.hasDefined("jgroups-discovery-group")) {
            for (Property prop : model.get("jgroups-discovery-group").asPropertyList()) {
                configs.put(prop.getName(), new DiscoveryGroupConfiguration().setName(prop.getName()).setRefreshTimeout(DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, prop.getValue()).asLong()).setDiscoveryInitialWaitTimeout(DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, prop.getValue()).asLong()));
            }
        }
        if (model.hasDefined("socket-discovery-group")) {
            for (Property prop : model.get("socket-discovery-group").asPropertyList()) {
                configs.put(prop.getName(), new DiscoveryGroupConfiguration().setName(prop.getName()).setRefreshTimeout(DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, prop.getValue()).asLong()).setDiscoveryInitialWaitTimeout(DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, prop.getValue()).asLong()));
            }
        }
        return configs;
    }

    static void addBridgeConfigurations(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("bridge")) {
            List configs = configuration.getBridgeConfigurations();
            for (Property prop : model.get("bridge").asPropertyList()) {
                configs.add(BridgeAdd.createBridgeConfiguration((ExpressionResolver)context, prop.getName(), prop.getValue()));
            }
        }
    }

    static void addGroupingHandlerConfiguration(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("grouping-handler")) {
            Property prop = model.get("grouping-handler").asProperty();
            String name = prop.getName();
            ModelNode node = prop.getValue();
            GroupingHandlerConfiguration.TYPE type = GroupingHandlerConfiguration.TYPE.valueOf((String)GroupingHandlerDefinition.TYPE.resolveModelAttribute(context, node).asString());
            String address = GroupingHandlerDefinition.GROUPING_HANDLER_ADDRESS.resolveModelAttribute(context, node).asString();
            int timeout = GroupingHandlerDefinition.TIMEOUT.resolveModelAttribute(context, node).asInt();
            long groupTimeout = GroupingHandlerDefinition.GROUP_TIMEOUT.resolveModelAttribute(context, node).asLong();
            long reaperPeriod = GroupingHandlerDefinition.REAPER_PERIOD.resolveModelAttribute(context, node).asLong();
            GroupingHandlerConfiguration conf = new GroupingHandlerConfiguration().setName(SimpleString.toSimpleString((String)name)).setType(type).setAddress(SimpleString.toSimpleString((String)address)).setTimeout((long)timeout).setGroupTimeout(groupTimeout).setReaperPeriod(reaperPeriod);
            configuration.setGroupingHandlerConfiguration(conf);
        }
    }

    static void addClusterConnectionConfigurations(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("cluster-connection")) {
            List configs = configuration.getClusterConfigurations();
            for (Property prop : model.get("cluster-connection").asPropertyList()) {
                configs.add(ConfigurationHelper.createClusterConnectionConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    private static ClusterConnectionConfiguration createClusterConnectionConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String address = ClusterConnectionDefinition.ADDRESS.resolveModelAttribute(context, model).asString();
        String connectorName = ClusterConnectionDefinition.CONNECTOR_NAME.resolveModelAttribute(context, model).asString();
        long retryInterval = ClusterConnectionDefinition.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        boolean duplicateDetection = ClusterConnectionDefinition.USE_DUPLICATE_DETECTION.resolveModelAttribute(context, model).asBoolean();
        long connectionTTL = ClusterConnectionDefinition.CONNECTION_TTL.resolveModelAttribute(context, model).asInt();
        int initialConnectAttempts = ClusterConnectionDefinition.INITIAL_CONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        int reconnectAttempts = ClusterConnectionDefinition.RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        long maxRetryInterval = ClusterConnectionDefinition.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        double retryIntervalMultiplier = ClusterConnectionDefinition.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble();
        long clientFailureCheckPeriod = ClusterConnectionDefinition.CHECK_PERIOD.resolveModelAttribute(context, model).asInt();
        String messageLoadBalancingType = ClusterConnectionDefinition.MESSAGE_LOAD_BALANCING_TYPE.resolveModelAttribute(context, model).asString();
        int maxHops = ClusterConnectionDefinition.MAX_HOPS.resolveModelAttribute(context, model).asInt();
        int confirmationWindowSize = CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt();
        int producerWindowSize = ClusterConnectionDefinition.PRODUCER_WINDOW_SIZE.resolveModelAttribute(context, model).asInt();
        ModelNode discoveryNode = ClusterConnectionDefinition.DISCOVERY_GROUP_NAME.resolveModelAttribute(context, model);
        int minLargeMessageSize = CommonAttributes.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt();
        long callTimeout = CommonAttributes.CALL_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long callFailoverTimeout = ClusterConnectionDefinition.CALL_FAILOVER_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long clusterNotificationInterval = ClusterConnectionDefinition.NOTIFICATION_INTERVAL.resolveModelAttribute(context, model).asLong();
        int clusterNotificationAttempts = ClusterConnectionDefinition.NOTIFICATION_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        ClusterConnectionConfiguration config = new ClusterConnectionConfiguration().setName(name).setAddress(address).setConnectorName(connectorName).setMinLargeMessageSize(minLargeMessageSize).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setMaxRetryInterval(maxRetryInterval).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setCallTimeout(callTimeout).setCallFailoverTimeout(callFailoverTimeout).setDuplicateDetection(duplicateDetection).setMessageLoadBalancingType(MessageLoadBalancingType.valueOf((String)messageLoadBalancingType)).setMaxHops(maxHops).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setClusterNotificationInterval(clusterNotificationInterval).setClusterNotificationAttempts(clusterNotificationAttempts);
        String discoveryGroupName = discoveryNode.isDefined() ? discoveryNode.asString() : null;
        List<String> staticConnectors = discoveryGroupName == null ? ConfigurationHelper.getStaticConnectors(model) : null;
        boolean allowDirectOnly = ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY.resolveModelAttribute(context, model).asBoolean();
        if (discoveryGroupName != null) {
            config.setDiscoveryGroupName(discoveryGroupName);
        } else {
            config.setStaticConnectors(staticConnectors).setAllowDirectConnectionsOnly(allowDirectOnly);
        }
        return config;
    }

    private static List<String> getStaticConnectors(ModelNode model) {
        if (!model.hasDefined("static-connectors")) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ModelNode connector : model.require("static-connectors").asList()) {
            result.add(connector.asString());
        }
        return result;
    }

    static void addConnectorServiceConfigurations(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("connector-service")) {
            List configs = configuration.getConnectorServiceConfigurations();
            for (Property prop : model.get("connector-service").asPropertyList()) {
                configs.add(ConfigurationHelper.createConnectorServiceConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    private static ConnectorServiceConfiguration createConnectorServiceConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String factoryClass = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, model).asString();
        Map unwrappedParameters = CommonAttributes.PARAMS.unwrap((ExpressionResolver)context, model);
        HashMap parameters = new HashMap(unwrappedParameters);
        return new ConnectorServiceConfiguration().setFactoryClassName(factoryClass).setParams(parameters).setName(name);
    }
}

