/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenderKitConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String RENDERKIT = "render-kit";
    private static final String RENDERKIT_ID = "render-kit-id";
    private static final String RENDERKIT_CLASS = "render-kit-class";
    private static final String RENDERER = "renderer";
    private static final String RENDERER_FAMILY = "component-family";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String RENDERER_CLASS = "renderer-class";
    private static final String CLIENT_BEHAVIOR_RENDERER = "client-behavior-renderer";
    private static final String CLIENT_BEHAVIOR_RENDERER_TYPE = "client-behavior-renderer-type";
    private static final String CLIENT_BEHAVIOR_RENDERER_CLASS = "client-behavior-renderer-class";

    @Override
    public void process(ServletContext servletContext, FacesContext facesContext, DocumentInfo[] documentInfos) throws Exception {
        RenderKit renderKit;
        LinkedHashMap<String, Map<Document, List<Node>>> renderers = new LinkedHashMap<String, Map<Document, List<Node>>>();
        LinkedHashMap<String, Map<Document, List<Node>>> behaviorRenderers = new LinkedHashMap<String, Map<Document, List<Node>>>();
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing render-kit elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList renderkits = document.getDocumentElement().getElementsByTagNameNS(namespace, RENDERKIT);
            if (renderkits == null || renderkits.getLength() <= 0) continue;
            this.addRenderKits(servletContext, facesContext, renderkits, document, renderers, behaviorRenderers, renderKitFactory);
        }
        this.processAnnotations(facesContext, FacesRenderer.class);
        this.processAnnotations(facesContext, FacesBehaviorRenderer.class);
        for (Map.Entry entry : renderers.entrySet()) {
            renderKit = renderKitFactory.getRenderKit(null, (String)entry.getKey());
            if (renderKit == null) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.CONFIG_RENDERER_REGISTRATION_MISSING_RENDERKIT", entry.getKey()));
            }
            for (Map.Entry renderEntry : ((Map)entry.getValue()).entrySet()) {
                this.addRenderers(servletContext, facesContext, renderKit, (Document)renderEntry.getKey(), (List)renderEntry.getValue());
            }
        }
        for (Map.Entry entry : behaviorRenderers.entrySet()) {
            renderKit = renderKitFactory.getRenderKit(null, (String)entry.getKey());
            if (renderKit == null) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.CONFIG_RENDERER_REGISTRATION_MISSING_RENDERKIT", entry.getKey()));
            }
            for (Map.Entry renderEntry : ((Map)entry.getValue()).entrySet()) {
                this.addClientBehaviorRenderers(servletContext, facesContext, renderKit, (Document)renderEntry.getKey(), (List)renderEntry.getValue());
            }
        }
    }

    private void addRenderKits(ServletContext sc, FacesContext facesContext, NodeList renderKits, Document owningDocument, Map<String, Map<Document, List<Node>>> renderers, Map<String, Map<Document, List<Node>>> behaviorRenderers, RenderKitFactory renderKitFactory) {
        String namespace = owningDocument.getDocumentElement().getNamespaceURI();
        int size = renderKits.getLength();
        for (int i = 0; i < size; ++i) {
            Map<Document, List<Node>> existingRenderers;
            Node renderKitNode = renderKits.item(i);
            NodeList children = ((Element)renderKitNode).getElementsByTagNameNS(namespace, "*");
            String renderKitId = null;
            String renderKitClass = null;
            ArrayList<Node> renderersList = new ArrayList<Node>(children.getLength());
            ArrayList<Node> behaviorRenderersList = new ArrayList<Node>(children.getLength());
            int csize = children.getLength();
            block13: for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                switch (n.getLocalName()) {
                    case "render-kit-id": {
                        renderKitId = this.getNodeText(n);
                        continue block13;
                    }
                    case "render-kit-class": {
                        renderKitClass = this.getNodeText(n);
                        continue block13;
                    }
                    case "renderer": {
                        renderersList.add(n);
                        continue block13;
                    }
                    case "client-behavior-renderer": {
                        behaviorRenderersList.add(n);
                    }
                }
            }
            String string = renderKitId = renderKitId == null ? "HTML_BASIC" : renderKitId;
            if (renderKitClass != null) {
                RenderKit previousRenderKit = renderKitFactory.getRenderKit(facesContext, renderKitId);
                RenderKit renderKit = (RenderKit)this.createInstance(sc, facesContext, renderKitClass, RenderKit.class, previousRenderKit, renderKitNode);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKitFactory.addRenderKit({0}, {1})", renderKitId, renderKitClass));
                }
                renderKitFactory.addRenderKit(renderKitId, renderKit);
            }
            if ((existingRenderers = renderers.get(renderKitId)) != null) {
                List<Node> list = existingRenderers.get(owningDocument);
                if (list != null) {
                    list.addAll(renderersList);
                } else {
                    existingRenderers.put(owningDocument, renderersList);
                }
            } else {
                existingRenderers = new LinkedHashMap<Document, List<Node>>();
                existingRenderers.put(owningDocument, renderersList);
            }
            renderers.put(renderKitId, existingRenderers);
            Map<Document, List<Node>> existingBehaviorRenderers = behaviorRenderers.get(renderKitId);
            if (existingBehaviorRenderers != null) {
                List<Node> list = existingBehaviorRenderers.get(owningDocument);
                if (list != null) {
                    list.addAll(behaviorRenderersList);
                } else {
                    existingBehaviorRenderers.put(owningDocument, behaviorRenderersList);
                }
            } else {
                existingBehaviorRenderers = new LinkedHashMap<Document, List<Node>>();
                existingBehaviorRenderers.put(owningDocument, behaviorRenderersList);
            }
            behaviorRenderers.put(renderKitId, existingBehaviorRenderers);
        }
    }

    private void addRenderers(ServletContext sc, FacesContext facesContext, RenderKit renderKit, Document owningDocument, List<Node> renderers) {
        String namespace = owningDocument.getDocumentElement().getNamespaceURI();
        for (Node rendererNode : renderers) {
            Renderer renderer;
            NodeList children = ((Element)rendererNode).getElementsByTagNameNS(namespace, "*");
            String rendererFamily = null;
            String rendererType = null;
            String rendererClass = null;
            int size = children.getLength();
            block11: for (int i = 0; i < size; ++i) {
                Node n = children.item(i);
                switch (n.getLocalName()) {
                    case "component-family": {
                        rendererFamily = this.getNodeText(n);
                        continue block11;
                    }
                    case "renderer-type": {
                        rendererType = this.getNodeText(n);
                        continue block11;
                    }
                    case "renderer-class": {
                        rendererClass = this.getNodeText(n);
                    }
                }
            }
            if (rendererFamily == null || rendererType == null || rendererClass == null || (renderer = (Renderer)this.createInstance(sc, facesContext, rendererClass, Renderer.class, null, rendererNode)) == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKit.addRenderer({0},{1}, {2}) for RenderKit ''{3}''", rendererFamily, rendererType, rendererClass, renderKit.getClass()));
            }
            renderKit.addRenderer(rendererFamily, rendererType, renderer);
        }
    }

    private void addClientBehaviorRenderers(ServletContext servletContext, FacesContext facesContext, RenderKit renderKit, Document owningDocument, List<Node> behaviorRenderers) {
        String namespace = owningDocument.getDocumentElement().getNamespaceURI();
        for (Node behaviorRendererNode : behaviorRenderers) {
            ClientBehaviorRenderer behaviorRenderer;
            NodeList children = ((Element)behaviorRendererNode).getElementsByTagNameNS(namespace, "*");
            String behaviorRendererType = null;
            String behaviorRendererClass = null;
            int size = children.getLength();
            block9: for (int i = 0; i < size; ++i) {
                Node n = children.item(i);
                switch (n.getLocalName()) {
                    case "client-behavior-renderer-type": {
                        behaviorRendererType = this.getNodeText(n);
                        continue block9;
                    }
                    case "client-behavior-renderer-class": {
                        behaviorRendererClass = this.getNodeText(n);
                    }
                }
            }
            if (behaviorRendererType == null || behaviorRendererClass == null || (behaviorRenderer = (ClientBehaviorRenderer)this.createInstance(servletContext, facesContext, behaviorRendererClass, ClientBehaviorRenderer.class, null, behaviorRendererNode)) == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKit.addClientBehaviorRenderer({0},{1}, {2}) for RenderKit ''{2}''", behaviorRendererType, behaviorRendererClass, renderKit.getClass()));
            }
            renderKit.addClientBehaviorRenderer(behaviorRendererType, behaviorRenderer);
        }
    }
}

