/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.opentelemetry.OpenTelemetryModel;
import org.wildfly.extension.opentelemetry.OpenTelemetryParser;
import org.wildfly.extension.opentelemetry.OpenTelemetrySchema;
import org.wildfly.extension.opentelemetry.OpenTelemetrySubsystemDefinition;

public class OpenTelemetrySubsystemExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "opentelemetry";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"opentelemetry");
    private static final String RESOURCE_NAME = OpenTelemetrySubsystemExtension.class.getPackage().getName() + ".LocalDescriptions";

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, OpenTelemetrySubsystemExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, OpenTelemetryModel.CURRENT.getVersion());
        subsystem.registerXMLElementWriter((XMLElementWriter)new OpenTelemetryParser(OpenTelemetrySchema.CURRENT));
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new OpenTelemetrySubsystemDefinition());
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (OpenTelemetrySchema schema : EnumSet.allOf(OpenTelemetrySchema.class)) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new OpenTelemetryParser(schema));
        }
    }
}

