/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.impl.connectionfactory;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ManagedConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

public class ManagedConnectionFactory
extends ConnectionFactory {
    private static final Log log = (Log)LogFactory.getLog(ManagedConnectionFactory.class, Log.class);
    private DataSource dataSource;

    @Override
    public void start(ConnectionFactoryConfiguration factoryConfiguration, ClassLoader classLoader) throws PersistenceException {
        InitialContext ctx = null;
        if (!(factoryConfiguration instanceof ManagedConnectionFactoryConfiguration)) {
            throw new PersistenceException("FactoryConfiguration has to be an instance of ManagedConnectionFactoryConfiguration");
        }
        ManagedConnectionFactoryConfiguration managedConfiguration = (ManagedConnectionFactoryConfiguration)factoryConfiguration;
        String datasourceName = managedConfiguration.jndiUrl();
        try {
            ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(datasourceName);
            if (log.isTraceEnabled()) {
                log.tracef("Datasource lookup for %s succeeded: %b", datasourceName, this.dataSource);
            }
            if (this.dataSource == null) {
                Log.PERSISTENCE.connectionInJndiNotFound(datasourceName);
                throw new PersistenceException(String.format("Could not find a connection in jndi under the name '%s'", datasourceName));
            }
        }
        catch (NamingException e) {
            Log.PERSISTENCE.namingExceptionLookingUpConnection(datasourceName, e);
            throw new PersistenceException((Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    Log.PERSISTENCE.failedClosingNamingCtx(e);
                }
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Connection getConnection() throws PersistenceException {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            Log.PERSISTENCE.sqlFailureRetrievingConnection(e);
            throw new PersistenceException("This might be related to https://jira.jboss.org/browse/ISPN-604", (Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Connection checked out: %s", connection);
        }
        return connection;
    }

    @Override
    public void releaseConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            Log.PERSISTENCE.sqlFailureClosingConnection(conn, e);
        }
    }
}

