/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.distribution;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashKeyDistribution;
import org.wildfly.clustering.infinispan.spi.distribution.KeyDistribution;
import org.wildfly.clustering.infinispan.spi.distribution.LocalKeyDistribution;

public class CacheKeyDistribution
implements KeyDistribution {
    private final DistributionManager distribution;
    private final KeyPartitioner partitioner;

    public CacheKeyDistribution(Cache<?, ?> cache) {
        this.distribution = cache.getAdvancedCache().getDistributionManager();
        this.partitioner = (KeyPartitioner)cache.getAdvancedCache().getComponentRegistry().getLocalComponent(KeyPartitioner.class);
    }

    @Override
    public Address getPrimaryOwner(Object key) {
        return this.getCurrentKeyDistribution().getPrimaryOwner(key);
    }

    @Override
    public List<Address> getOwners(Object key) {
        return this.getCurrentKeyDistribution().getOwners(key);
    }

    private KeyDistribution getCurrentKeyDistribution() {
        return this.distribution != null ? new ConsistentHashKeyDistribution(this.partitioner, this.distribution.getCacheTopology().getWriteConsistentHash()) : LocalKeyDistribution.INSTANCE;
    }
}

