/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.dynamicresource.ClearStatisticsHandler;
import org.jboss.as.connector.dynamicresource.StatisticsResourceDefinition;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.subsystems.common.pool.PoolMetrics;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResourceCreator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.api.management.AdminObject;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.ManagedConnectionFactory;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class IronJacamarActivationResourceService
implements Service<ManagementResourceRegistration> {
    private static PathElement SUBSYSTEM_PATH_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
    private static PathAddress RA_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{SUBSYSTEM_PATH_ELEMENT, PathElement.pathElement((String)"ironjacamar", (String)"ironjacamar"), PathElement.pathElement((String)"resource-adapter")});
    private final ManagementResourceRegistration registration;
    private final Resource deploymentResource;
    private final boolean statsEnabled;
    private final InjectedValue<ResourceAdapterDeployment> deployment = new InjectedValue();
    private final InjectedValue<AS7MetadataRepository> mdr = new InjectedValue();

    public IronJacamarActivationResourceService(ManagementResourceRegistration registration, Resource deploymentResource, boolean statsEnabled) {
        this.registration = registration;
        this.deploymentResource = deploymentResource;
        this.statsEnabled = statsEnabled;
    }

    public void start(StartContext context) throws StartException {
        IronJacamarResource.IronJacamarRuntimeResource subsystemResource;
        CommonDeployment deploymentMD = ((ResourceAdapterDeployment)this.deployment.getValue()).getDeployment();
        String deploymentName = deploymentMD.getDeploymentName();
        ConnectorLogger.ROOT_LOGGER.debugf("Starting IronJacamarActivationResourceService %s", deploymentName);
        try {
            Connector connector = deploymentMD.getConnector();
            if (connector != null && connector.getResourceAdapter() != null) {
                List adminObjects;
                ConnectionManager[] connectionManagers;
                List connectionFactories;
                OverrideDescriptionProvider OD_PROVIDER = new OverrideDescriptionProvider(){

                    public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                        return Collections.emptyMap();
                    }

                    public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                        return Collections.emptyMap();
                    }
                };
                PathElement EXTENDED_STATS = PathElement.pathElement((String)"statistics", (String)"extended");
                PathAddress EXTENDED_STATS_ADDR = PathAddress.pathAddress((PathElement[])new PathElement[]{EXTENDED_STATS});
                PathAddress CON_DEF_ADDR = PathAddress.EMPTY_ADDRESS.append("connection-definitions");
                ManagementResourceRegistration raRegistration = this.registration.getSubModel(RA_ADDRESS).registerOverrideModel(deploymentName, OD_PROVIDER);
                ResourceBuilder resourceBuilder = ResourceBuilder.Factory.create((PathElement)EXTENDED_STATS, (StandardResourceDescriptionResolver)new StandardResourceDescriptionResolver("statistics.workmanager", CommonAttributes.RESOURCE_NAME, CommonAttributes.class.getClassLoader()));
                ManagementResourceRegistration raStatsSubRegistration = raRegistration.registerSubModel(resourceBuilder.build());
                StatisticsPlugin raStats = connector.getResourceAdapter().getStatistics();
                if (raStats != null) {
                    raStats.setEnabled(this.statsEnabled);
                    PoolMetrics.ParametrizedPoolMetricsHandler handler = new PoolMetrics.ParametrizedPoolMetricsHandler(raStats);
                    for (AttributeDefinition attribute : StatisticsResourceDefinition.getAttributesFromPlugin(raStats)) {
                        raStatsSubRegistration.registerMetric(attribute, (OperationStepHandler)handler);
                    }
                    raStatsSubRegistration.registerOperationHandler(ClearStatisticsHandler.DEFINITION, (OperationStepHandler)new ClearStatisticsHandler(raStats));
                }
                if ((connectionFactories = connector.getConnectionFactories()) != null) {
                    for (ConnectionFactory cf : connectionFactories) {
                        ManagementResourceRegistration cdRegistration;
                        ManagementResourceRegistration overrideCdRegistration;
                        ManagedConnectionFactory mcf = cf.getManagedConnectionFactory();
                        StatisticsPlugin extendStats = mcf == null ? null : mcf.getStatistics();
                        if (extendStats == null) continue;
                        extendStats.setEnabled(this.statsEnabled);
                        if (extendStats.getNames().isEmpty() || (overrideCdRegistration = (cdRegistration = raRegistration.getSubModel(CON_DEF_ADDR)).registerOverrideModel(cf.getJndiName(), OD_PROVIDER)).getSubModel(EXTENDED_STATS_ADDR) != null) continue;
                        overrideCdRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(EXTENDED_STATS, CommonAttributes.RESOURCE_NAME, extendStats));
                    }
                }
                if ((connectionManagers = deploymentMD.getConnectionManagers()) != null) {
                    PathElement POOL_STATS = PathElement.pathElement((String)"statistics", (String)"pool");
                    PathAddress POOL_STATS_ADDR = PathAddress.pathAddress((PathElement[])new PathElement[]{POOL_STATS});
                    for (ConnectionManager cm : connectionManagers) {
                        ManagementResourceRegistration cdRegistration;
                        ManagementResourceRegistration overrideCdRegistration;
                        if (cm.getPool() == null) continue;
                        PoolStatistics poolStats = cm.getPool().getStatistics();
                        poolStats.setEnabled(this.statsEnabled);
                        if (poolStats.getNames().isEmpty() || (overrideCdRegistration = (cdRegistration = raRegistration.getSubModel(CON_DEF_ADDR)).registerOverrideModel(cm.getJndiName(), OD_PROVIDER)).getSubModel(POOL_STATS_ADDR) != null) continue;
                        overrideCdRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(POOL_STATS, CommonAttributes.RESOURCE_NAME, (StatisticsPlugin)poolStats));
                    }
                }
                if ((adminObjects = connector.getAdminObjects()) != null) {
                    PathAddress AO_ADDR = PathAddress.EMPTY_ADDRESS.append("admin-objects");
                    for (AdminObject ao : adminObjects) {
                        ManagementResourceRegistration cdRegistration;
                        ManagementResourceRegistration overrideCdRegistration;
                        StatisticsPlugin extendStats = ao.getStatistics();
                        if (extendStats == null) continue;
                        extendStats.setEnabled(this.statsEnabled);
                        if (extendStats.getNames().isEmpty() || (overrideCdRegistration = (cdRegistration = raRegistration.getSubModel(AO_ADDR)).registerOverrideModel(ao.getJndiName(), OD_PROVIDER)).getSubModel(EXTENDED_STATS_ADDR) != null) continue;
                        overrideCdRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(EXTENDED_STATS, CommonAttributes.RESOURCE_NAME, extendStats));
                    }
                }
            }
        }
        catch (IllegalArgumentException connector) {
            // empty catch block
        }
        if (!this.deploymentResource.hasChild(SUBSYSTEM_PATH_ELEMENT)) {
            subsystemResource = new IronJacamarResource.IronJacamarRuntimeResource();
            this.deploymentResource.registerChild(SUBSYSTEM_PATH_ELEMENT, (Resource)subsystemResource);
        } else {
            subsystemResource = this.deploymentResource.getChild(SUBSYSTEM_PATH_ELEMENT);
        }
        IronJacamarResourceCreator.INSTANCE.execute((Resource)subsystemResource, (AS7MetadataRepository)this.mdr.getValue(), ((ResourceAdapterDeployment)this.deployment.getValue()).getRaName());
    }

    public void stop(StopContext context) {
        CommonDeployment deploymentMD = ((ResourceAdapterDeployment)this.deployment.getValue()).getDeployment();
        String deploymentName = deploymentMD.getDeploymentName();
        ConnectorLogger.ROOT_LOGGER.debugf("Stopping IronJacamarActivationResourceService %s", deploymentName);
        Connector connector = deploymentMD.getConnector();
        if (connector != null && connector.getResourceAdapter() != null) {
            List adminObjects;
            ConnectionFactory connectionManagers;
            ManagementResourceRegistration raReg = this.registration.getSubModel(RA_ADDRESS.getParent().append("resource-adapter", deploymentName));
            ManagementResourceRegistration cdefReg = raReg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"connection-definitions")}));
            List connectionFactories = connector.getConnectionFactories();
            if (connectionFactories != null) {
                for (ConnectionFactory cf : connectionFactories) {
                    cdefReg.unregisterOverrideModel(cf.getJndiName());
                }
            }
            if ((connectionManagers = deploymentMD.getConnectionManagers()) != null) {
                for (ConnectionFactory cm : connectionManagers) {
                    cdefReg.unregisterOverrideModel(cm.getJndiName());
                }
            }
            if ((adminObjects = connector.getAdminObjects()) != null) {
                ManagementResourceRegistration aoReg = raReg.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"admin-objects")}));
                for (AdminObject ao : adminObjects) {
                    aoReg.unregisterOverrideModel(ao.getJndiName());
                }
            }
            ManagementResourceRegistration raBaseReg = this.registration.getSubModel(RA_ADDRESS);
            raBaseReg.unregisterOverrideModel(deploymentName);
        }
        this.deploymentResource.removeChild(SUBSYSTEM_PATH_ELEMENT);
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.registration;
    }

    public Injector<AS7MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public Injector<ResourceAdapterDeployment> getResourceAdapterDeploymentInjector() {
        return this.deployment;
    }
}

