/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.affinity;

import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;

public class AffinityIdentifierFactory<I>
implements IdentifierFactory<I>,
KeyGenerator<Key<I>> {
    private final Supplier<I> factory;
    private final KeyAffinityService<? extends Key<I>> affinity;
    private final Address localAddress;

    public AffinityIdentifierFactory(Supplier<I> factory, Cache<? extends Key<I>, ?> cache, KeyAffinityServiceFactory affinityFactory) {
        this.factory = factory;
        this.affinity = affinityFactory.createService(cache, (KeyGenerator)this);
        this.localAddress = cache.getCacheManager().getAddress();
    }

    public I get() {
        return (I)((Key)this.affinity.getKeyForAddress(this.localAddress)).getId();
    }

    public Key<I> getKey() {
        return new GroupedKey<I>(this.factory.get());
    }

    public void start() {
        this.affinity.start();
    }

    public void stop() {
        this.affinity.stop();
    }
}

