/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.LoginConfig;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.wildfly.elytron.web.undertow.server.ElytronRunAsHandler;
import org.wildfly.elytron.web.undertow.server.ScopeSessionListener;
import org.wildfly.elytron.web.undertow.server.servlet.CleanUpHandler;
import org.wildfly.elytron.web.undertow.server.servlet.ElytronAuthorizationManager;
import org.wildfly.elytron.web.undertow.server.servlet.ElytronHttpServletExchange;
import org.wildfly.elytron.web.undertow.server.servlet.ElytronServletContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.servlet.IdentityMapping;
import org.wildfly.elytron.web.undertow.server.servlet.RunAsLifecycleInterceptor;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.util.PropertiesServerMechanismFactory;

public class AuthenticationManager {
    private final Builder builder;

    AuthenticationManager(Builder builder) {
        this.builder = builder;
    }

    public void configure(DeploymentInfo deploymentInfo) {
        SecurityDomain securityDomain;
        ScopeSessionListener scopeSessionListener = ScopeSessionListener.builder().addScopeResolver(Scope.APPLICATION, ElytronHttpServletExchange.APPLICATION_SCOPE_RESOLVER).build();
        HttpAuthenticationFactory httpAuthenticationFactory = this.builder.httpAuthenticationFactory;
        SecurityDomain securityDomain2 = securityDomain = httpAuthenticationFactory != null ? httpAuthenticationFactory.getSecurityDomain() : this.builder.securityDomain;
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                securityDomain.registerWithClassLoader(deploymentInfo.getClassLoader());
                return null;
            });
        } else {
            securityDomain.registerWithClassLoader(deploymentInfo.getClassLoader());
        }
        deploymentInfo.addSessionListener((SessionListener)scopeSessionListener);
        Function runAsMapper = this.builder.runAsMapper;
        deploymentInfo.addInnerHandlerChainWrapper(h -> this.finalSecurityHandlers(h, securityDomain, runAsMapper));
        deploymentInfo.setInitialSecurityWrapper(h -> this.initialSecurityHandler(deploymentInfo, h, securityDomain, scopeSessionListener));
        if (runAsMapper != null) {
            deploymentInfo.addLifecycleInterceptor((LifecycleInterceptor)new RunAsLifecycleInterceptor(runAsMapper, securityDomain));
        }
        if (this.builder.authorizationManager != null) {
            deploymentInfo.setAuthorizationManager(this.builder.authorizationManager);
        } else {
            deploymentInfo.setAuthorizationManager((AuthorizationManager)new ElytronAuthorizationManager(securityDomain));
        }
    }

    private HttpHandler initialSecurityHandler(DeploymentInfo deploymentInfo, HttpHandler toWrap, SecurityDomain securityDomain, ScopeSessionListener scopeSessionListener) {
        Collection<Object> availableMechanisms;
        HttpAuthenticationFactory httpAuthenticationFactory = this.builder.httpAuthenticationFactory;
        if (httpAuthenticationFactory != null) {
            availableMechanisms = this.builder.httpAuthenticationFactory.getMechanismNames();
            if (availableMechanisms.isEmpty()) {
                throw new IllegalStateException("There are no mechanisms available from the HttpAuthenticationFactory.");
            }
        } else {
            availableMechanisms = Collections.emptyList();
        }
        HashMap<String, String> tempBaseConfiguration = new HashMap<String, String>();
        tempBaseConfiguration.put(HttpConstants.CONFIG_CONTEXT_PATH, deploymentInfo.getContextPath());
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        if (loginConfig != null) {
            String errorPage;
            String loginPage;
            String realm = loginConfig.getRealmName();
            if (realm != null) {
                tempBaseConfiguration.put(HttpConstants.CONFIG_REALM, realm);
            }
            if ((loginPage = loginConfig.getLoginPage()) != null) {
                tempBaseConfiguration.put(HttpConstants.CONFIG_LOGIN_PAGE, loginPage);
            }
            if ((errorPage = loginConfig.getErrorPage()) != null) {
                tempBaseConfiguration.put(HttpConstants.CONFIG_ERROR_PAGE, errorPage);
            }
        }
        Map baseConfiguration = Collections.unmodifiableMap(tempBaseConfiguration);
        LinkedHashMap selectedMechanisms = new LinkedHashMap();
        if (this.builder.overrideDeploymentConfig) {
            Map mechanismConfiguration = baseConfiguration;
            for (String string : availableMechanisms) {
                selectedMechanisms.put(string, mechanismConfiguration);
            }
        } else if (loginConfig != null) {
            List authMethods = loginConfig.getAuthMethods();
            if (authMethods.isEmpty()) {
                throw new IllegalStateException("No authentication mechanisms have been selected.");
            }
            for (AuthMethodConfig authMethodConfig : authMethods) {
                Map mechanismConfiguration;
                String name = authMethodConfig.getName();
                if (!availableMechanisms.contains(name)) {
                    throw new IllegalStateException(String.format("The required mechanism '%s' is not available in mechanisms %s from the HttpAuthenticationFactory.", name, availableMechanisms));
                }
                Map additionalProperties = authMethodConfig.getProperties();
                if (additionalProperties != null) {
                    mechanismConfiguration = new HashMap(baseConfiguration);
                    mechanismConfiguration.putAll(additionalProperties);
                    mechanismConfiguration = Collections.unmodifiableMap(mechanismConfiguration);
                } else {
                    mechanismConfiguration = baseConfiguration;
                }
                selectedMechanisms.put(name, mechanismConfiguration);
            }
        }
        String deploymentPath = deploymentInfo.getContextPath();
        String applicationContext = deploymentInfo.getHostName() + " " + (deploymentPath.equals("/") ? "" : deploymentPath);
        HttpHandler httpHandler = ElytronServletContextAssociationHandler.builder().setApplicationContext(applicationContext).setEnableJaspi(this.builder.enableJaspi).setIntegratedJaspi(this.builder.integratedJapi).setNext(toWrap).setSecurityDomain(securityDomain).setMechanismSupplier(() -> this.getAuthenticationMechanisms(selectedMechanisms)).setAuthenticationMode(deploymentInfo.getAuthenticationMode()).setHttpExchangeSupplier(httpServerExchange -> new ElytronHttpServletExchange((HttpServerExchange)httpServerExchange, scopeSessionListener)).setIdentityCacheSupplier(this.builder.identityCacheSupplier).build();
        return new CleanUpHandler(httpHandler);
    }

    private HttpHandler finalSecurityHandlers(HttpHandler toWrap, SecurityDomain securityDomain, Function<String, RunAsIdentityMetaData> runAsMapper) {
        return runAsMapper != null ? new ElytronRunAsHandler(toWrap, (s, e) -> IdentityMapping.mapIdentity(s, securityDomain, e, runAsMapper)) : new ElytronRunAsHandler(toWrap);
    }

    private List<HttpServerAuthenticationMechanism> getAuthenticationMechanisms(Map<String, Map<String, String>> selectedMechanisms) {
        ArrayList<HttpServerAuthenticationMechanism> mechanisms = new ArrayList<HttpServerAuthenticationMechanism>(selectedMechanisms.size());
        UnaryOperator singleSignOnTransformer = this.builder.httpAuthenticationFactoryTransformer;
        for (Map.Entry<String, Map<String, String>> entry : selectedMechanisms.entrySet()) {
            try {
                UnaryOperator factoryTransformation = f -> {
                    PropertiesServerMechanismFactory factory = new PropertiesServerMechanismFactory(f, (Map)entry.getValue());
                    return singleSignOnTransformer != null ? (HttpServerAuthenticationMechanismFactory)singleSignOnTransformer.apply(factory) : factory;
                };
                HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)this.builder.httpAuthenticationFactory.createMechanism(entry.getKey(), factoryTransformation);
                if (mechanism == null) continue;
                mechanisms.add(mechanism);
            }
            catch (HttpAuthenticationException e) {
                throw new IllegalStateException(e);
            }
        }
        return mechanisms;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpAuthenticationFactory httpAuthenticationFactory;
        private SecurityDomain securityDomain;
        private boolean overrideDeploymentConfig;
        private AuthorizationManager authorizationManager;
        private UnaryOperator<HttpServerAuthenticationMechanismFactory> httpAuthenticationFactoryTransformer;
        private Function<String, RunAsIdentityMetaData> runAsMapper;
        private boolean enableJaspi = true;
        private boolean integratedJapi = true;
        private BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier;
        private boolean built = false;

        public Builder setHttpAuthenticationFactory(HttpAuthenticationFactory httpAuthenticationFactory) {
            this.assertNotBuilt();
            if (httpAuthenticationFactory != null && this.securityDomain != null) {
                throw new IllegalStateException("HttpAuthenticationFactory and SecurityDomain can not both be set at the same time.");
            }
            this.httpAuthenticationFactory = httpAuthenticationFactory;
            return this;
        }

        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.assertNotBuilt();
            if (this.httpAuthenticationFactory != null && securityDomain != null) {
                throw new IllegalStateException("HttpAuthenticationFactory and SecurityDomain can not both be set at the same time.");
            }
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setAuthorizationManager(AuthorizationManager authorizationManager) {
            this.assertNotBuilt();
            this.authorizationManager = authorizationManager;
            return this;
        }

        public Builder setOverrideDeploymentConfig(boolean overrideDeploymentConfig) {
            this.assertNotBuilt();
            this.overrideDeploymentConfig = overrideDeploymentConfig;
            return this;
        }

        public Builder setHttpAuthenticationFactoryTransformer(UnaryOperator<HttpServerAuthenticationMechanismFactory> httpAuthenticationFactoryTransformer) {
            this.assertNotBuilt();
            this.httpAuthenticationFactoryTransformer = httpAuthenticationFactoryTransformer;
            return this;
        }

        public Builder setRunAsMapper(Function<String, RunAsIdentityMetaData> runAsMapper) {
            this.assertNotBuilt();
            this.runAsMapper = runAsMapper;
            return this;
        }

        public Builder setEnableJaspi(boolean enableJaspi) {
            this.assertNotBuilt();
            this.enableJaspi = enableJaspi;
            return this;
        }

        public Builder setIntegratedJaspi(boolean integratedJaspi) {
            this.assertNotBuilt();
            this.integratedJapi = integratedJaspi;
            return this;
        }

        public Builder setIdentityCacheSupplier(BiFunction<HttpExchangeSpi, String, IdentityCache> identityCacheSupplier) {
            this.assertNotBuilt();
            this.identityCacheSupplier = identityCacheSupplier;
            return this;
        }

        public AuthenticationManager build() {
            this.assertNotBuilt();
            this.built = true;
            return new AuthenticationManager(this);
        }

        void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("Builder already built.");
            }
        }
    }
}

