/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.logging;

import java.net.InetAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleNotFoundException;

@MessageLogger(projectCode="WFLYDMHTTP", length=4)
public interface HttpServerLogger
extends BasicLogger {
    public static final HttpServerLogger ROOT_LOGGER = (HttpServerLogger)Logger.getMessageLogger(HttpServerLogger.class, (String)"org.jboss.as.domain.http.api.undertow");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Unexpected error executing model request")
    public void modelRequestError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Unexpected error executing deployment upload request")
    public void uploadError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Unable to load console module for slot %s, disabling console")
    public void consoleModuleNotFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Unable to load error context for slot %s, disabling error context.")
    public void errorContextModuleNotFound(String var1);

    @Message(id=5, value="Invalid operation '%s'")
    public IllegalArgumentException invalidOperation(@Cause Throwable var1, String var2);

    @Message(id=6, value="The security realm is not ready to process requests, see %s")
    public String realmNotReadyMessage(String var1);

    @Message(id=7, value="No console module available with module name %s")
    public ModuleNotFoundException consoleModuleNotFoundMsg(String var1);

    @Message(id=10, value="Invalid Credential Type '%s'")
    public IllegalArgumentException invalidCredentialType(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Management interface is using different addresses for HTTP (%s) and HTTPS (%s). Redirection of HTTPS requests from HTTP socket to HTTPS socket will not be supported.")
    public void httpsRedirectNotSupported(InetAddress var1, InetAddress var2);

    @Message(id=12, value="A secure socket has been defined for the HTTP interface, however the referenced security realm is not supplying a SSLContext.")
    public IllegalArgumentException sslRequestedNoSslContext();

    @Message(id=13, value="Invalid useStreamIndex value '%d'. The operation response had %d streams attached.")
    public String invalidUseStreamAsResponseIndex(int var1, int var2);

    @Message(id=14, value="The ManagementHttpServer has already been built using this Builder.")
    public IllegalStateException managementHttpServerAlreadyBuild();

    @Message(id=15, value="No SecurityRealm or SSLContext has been provided.")
    public IllegalStateException noRealmOrSSLContext();

    @Message(id=16, value="Your Application Server is running. However you have not yet added any users to be able to access the HTTP management interface. To add a new user execute the %s script within the bin folder of your WildFly installation and enter the requested information. By default the realm name used by WildFly is 'ManagementRealm' and this is already selected by default by the add-user tool.")
    public String realmNotReadyForSecuredManagementHandler(String var1);
}

