/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.util.Map;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.serializer.MapSerializer;

public class MapToEntriesArraySerializer<K, V>
implements MapSerializer.Delegate<K, V> {
    private static final String DEFAULT_KEY_ENTRY_NAME = "key";
    private static final String DEFAULT_VALUE_ENTRY_NAME = "value";
    private final MapSerializer<K, V> serializer;
    private final String keyEntryName;
    private final String valueEntryName;

    protected MapToEntriesArraySerializer(MapSerializer<K, V> serializer) {
        this.serializer = serializer;
        this.keyEntryName = DEFAULT_KEY_ENTRY_NAME;
        this.valueEntryName = DEFAULT_VALUE_ENTRY_NAME;
    }

    @Override
    public void writeStart(JsonGenerator generator) {
        generator.writeStartArray();
    }

    @Override
    public void writeStart(String key, JsonGenerator generator) {
        generator.writeStartArray();
    }

    @Override
    public void serializeContainer(Map<K, V> obj, JsonGenerator generator, SerializationContext ctx) {
        obj.forEach((key, value) -> {
            generator.writeStartObject();
            generator.writeKey(this.keyEntryName);
            this.serializer.serializeKey();
            this.serializer.serializeItem(key, generator, ctx);
            generator.writeKey(this.valueEntryName);
            this.serializer.serializeValue();
            this.serializer.serializeItem(value, generator, ctx);
            generator.writeEnd();
        });
    }
}

