/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.interceptors.MetricName;
import io.smallrye.metrics.interceptors.MetricsParameter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Metric;

@Vetoed
class SeMetricName
implements MetricName {
    private final Set<MetricsParameter> parameters;

    SeMetricName(Set<MetricsParameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public String of(InjectionPoint ip) {
        Annotated annotated = ip.getAnnotated();
        if (annotated instanceof AnnotatedMember) {
            return this.of((AnnotatedMember)annotated);
        }
        if (annotated instanceof AnnotatedParameter) {
            return this.of((AnnotatedParameter)annotated);
        }
        throw SmallRyeMetricsMessages.msg.unableToRetrieveMetricNameForInjectionPoint(ip);
    }

    @Override
    public String of(AnnotatedMember<?> member) {
        if (member.isAnnotationPresent(Metric.class)) {
            Metric metric = (Metric)member.getAnnotation(Metric.class);
            String name = metric.name().isEmpty() ? member.getJavaMember().getName() : this.of(metric.name());
            return metric.absolute() | this.parameters.contains((Object)MetricsParameter.useAbsoluteName) ? name : MetricRegistry.name(member.getJavaMember().getDeclaringClass(), (String[])new String[]{name});
        }
        return this.parameters.contains((Object)MetricsParameter.useAbsoluteName) ? member.getJavaMember().getName() : MetricRegistry.name(member.getJavaMember().getDeclaringClass(), (String[])new String[]{member.getJavaMember().getName()});
    }

    @Override
    public String of(String attribute) {
        return attribute;
    }

    private String of(AnnotatedParameter<?> parameter) {
        if (parameter.isAnnotationPresent(Metric.class)) {
            Metric metric = (Metric)parameter.getAnnotation(Metric.class);
            String name = metric.name().isEmpty() ? this.getParameterName(parameter) : this.of(metric.name());
            return metric.absolute() | this.parameters.contains((Object)MetricsParameter.useAbsoluteName) ? name : MetricRegistry.name(parameter.getDeclaringCallable().getJavaMember().getDeclaringClass(), (String[])new String[]{name});
        }
        return this.parameters.contains((Object)MetricsParameter.useAbsoluteName) ? this.getParameterName(parameter) : MetricRegistry.name(parameter.getDeclaringCallable().getJavaMember().getDeclaringClass(), (String[])new String[]{this.getParameterName(parameter)});
    }

    private String getParameterName(AnnotatedParameter<?> parameter) {
        try {
            Method method = Method.class.getMethod("getParameters", new Class[0]);
            Object[] parameters = (Object[])method.invoke((Object)parameter.getDeclaringCallable().getJavaMember(), new Object[0]);
            Object param = parameters[parameter.getPosition()];
            Class<?> Parameter2 = Class.forName("java.lang.reflect.Parameter");
            if (((Boolean)Parameter2.getMethod("isNamePresent", new Class[0]).invoke(param, new Object[0])).booleanValue()) {
                return (String)Parameter2.getMethod("getName", new Class[0]).invoke(param, new Object[0]);
            }
            throw SmallRyeMetricsMessages.msg.unableToRetrieveParameterName(parameter);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException cause) {
            throw SmallRyeMetricsMessages.msg.unableToRetrieveParameterName(parameter);
        }
    }
}

