/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.LegacyConfigurationChangeResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.AccessIdentityResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.parsing.AccessControlXml;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class ManagementXml_18
implements ManagementXml {
    private final Namespace namespace;
    private final ManagementXmlDelegate delegate;
    private final boolean domainConfiguration;

    ManagementXml_18(Namespace namespace, ManagementXmlDelegate delegate, boolean domainConfiguration) {
        this.namespace = namespace;
        this.delegate = delegate;
        this.domainConfiguration = domainConfiguration;
    }

    @Override
    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (this.domainConfiguration) {
                if (element == Element.ACCESS_CONTROL) {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case AUDIT_LOG: {
                    if (this.delegate.parseAuditLog(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case ACCESS_CONTROL: {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case IDENTITY: {
                    this.parseIdentity(reader, managementAddress, list);
                    continue block7;
                }
                case CONFIGURATION_CHANGES: {
                    this.parseConfigurationChanges(reader, managementAddress, list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseConfigurationChanges(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)address);
        operationAddress = operationAddress.append(new PathElement[]{LegacyConfigurationChangeResourceDefinition.PATH});
        ModelNode add = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)operationAddress, (PathElement[])new PathElement[0]));
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_HISTORY: {
                    LegacyConfigurationChangeResourceDefinition.MAX_HISTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(add);
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseIdentity(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)address);
        operationAddress = operationAddress.append(new PathElement[]{AccessIdentityResourceDefinition.PATH_ELEMENT});
        ModelNode add = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)operationAddress, (PathElement[])new PathElement[0]));
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_DOMAIN: {
                    AccessIdentityResourceDefinition.SECURITY_DOMAIN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(add);
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    @Override
    public void writeManagement(XMLExtendedStreamWriter writer, ModelNode management, boolean allowInterfaces) throws XMLStreamException {
        ModelNode identity;
        boolean hasInterface = allowInterfaces && management.hasDefined("management-interface");
        ModelNode accessAuthorization = management.hasDefined("access") ? management.get(new String[]{"access", "authorization"}) : null;
        boolean accessAuthorizationDefined = accessAuthorization != null && accessAuthorization.isDefined();
        boolean hasServerGroupRoles = accessAuthorizationDefined && accessAuthorization.hasDefined("server-group-scoped-role");
        boolean hasConfigurationChanges = management.hasDefined(new String[]{"service", "configuration-changes"});
        boolean hasHostRoles = accessAuthorizationDefined && (accessAuthorization.hasDefined("host-scoped-role") || accessAuthorization.hasDefined("host-scoped-roles"));
        boolean hasRoleMapping = accessAuthorizationDefined && accessAuthorization.hasDefined("role-mapping");
        Map<String, Map<String, Set<String>>> configuredAccessConstraints = AccessControlXml.getConfiguredAccessConstraints(accessAuthorization);
        boolean hasProvider = accessAuthorizationDefined && accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PROVIDER.getName());
        boolean hasCombinationPolicy = accessAuthorizationDefined && accessAuthorization.hasDefined(AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName());
        ModelNode auditLog = management.hasDefined("access") ? management.get(new String[]{"access", "audit"}) : new ModelNode();
        ModelNode modelNode = identity = management.hasDefined("access") ? management.get(new String[]{"access", "identity"}) : new ModelNode();
        if (!(hasInterface || hasServerGroupRoles || hasHostRoles || hasRoleMapping || configuredAccessConstraints.size() != 0 || hasProvider || hasCombinationPolicy || auditLog.isDefined() || identity.isDefined())) {
            return;
        }
        writer.writeStartElement(Element.MANAGEMENT.getLocalName());
        if (hasConfigurationChanges) {
            this.writeConfigurationChanges(writer, management.get(new String[]{"service", "configuration-changes"}));
        }
        if (identity.isDefined()) {
            this.writeIdentity(writer, identity);
        }
        if (auditLog.isDefined() && !this.delegate.writeAuditLog(writer, auditLog)) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("audit");
        }
        if (allowInterfaces && hasInterface) {
            this.writeManagementInterfaces(writer, management);
        }
        if (accessAuthorizationDefined && !this.delegate.writeAccessControl(writer, accessAuthorization)) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("authorization");
        }
        writer.writeEndElement();
    }

    private void writeIdentity(XMLExtendedStreamWriter writer, ModelNode identity) throws XMLStreamException {
        writer.writeStartElement(Element.IDENTITY.getLocalName());
        AccessIdentityResourceDefinition.SECURITY_DOMAIN.marshallAsAttribute(identity, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeManagementInterfaces(XMLExtendedStreamWriter writer, ModelNode management) throws XMLStreamException {
        writer.writeStartElement(Element.MANAGEMENT_INTERFACES.getLocalName());
        ModelNode managementInterfaces = management.get("management-interface");
        if (managementInterfaces.hasDefined("native-remoting-interface")) {
            writer.writeEmptyElement(Element.NATIVE_REMOTING_INTERFACE.getLocalName());
        }
        if (managementInterfaces.hasDefined("native-interface") && !this.delegate.writeNativeManagementProtocol(writer, managementInterfaces.get("native-interface"))) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("native-interface");
        }
        if (managementInterfaces.hasDefined("http-interface") && !this.delegate.writeHttpManagementProtocol(writer, managementInterfaces.get("http-interface"))) {
            throw DomainManagementLogger.ROOT_LOGGER.unsupportedResource("http-interface");
        }
        writer.writeEndElement();
    }

    private void writeConfigurationChanges(XMLExtendedStreamWriter writer, ModelNode configurationChanges) throws XMLStreamException {
        writer.writeStartElement(Element.CONFIGURATION_CHANGES.getLocalName());
        LegacyConfigurationChangeResourceDefinition.MAX_HISTORY.marshallAsAttribute(configurationChanges, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }
}

