/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingGenerator;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.config.common.utils.StringUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigMappingInterface
implements ConfigMappingMetadata {
    static final ConfigMappingInterface[] NO_TYPES = new ConfigMappingInterface[0];
    static final Property[] NO_PROPERTIES = new Property[0];
    static final ClassValue<ConfigMappingInterface> cv = new ClassValue<ConfigMappingInterface>(){

        @Override
        protected ConfigMappingInterface computeValue(Class<?> type) {
            return ConfigMappingInterface.createConfigurationInterface(type);
        }
    };
    private final Class<?> interfaceType;
    private final String className;
    private final ConfigMappingInterface[] superTypes;
    private final Property[] properties;
    private final Map<String, Property> propertiesByName;
    private final NamingStrategy namingStrategy;
    private static final NamingStrategy DEFAULT_NAMING_STRATEGY = new KebabNamingStrategy();
    private static final NamingStrategy VERBATIM_NAMING_STRATEGY = new VerbatimNamingStrategy();
    private static final NamingStrategy KEBAB_CASE_NAMING_STRATEGY = new KebabNamingStrategy();
    private static final NamingStrategy SNAKE_CASE_NAMING_STRATEGY = new SnakeNamingStrategy();

    ConfigMappingInterface(Class<?> interfaceType, ConfigMappingInterface[] superTypes, Property[] properties) {
        this.interfaceType = interfaceType;
        this.className = interfaceType.getName() + interfaceType.getName().hashCode() + "Impl";
        this.superTypes = superTypes;
        this.properties = properties;
        this.propertiesByName = ConfigMappingInterface.toPropertiesMap(properties);
        this.namingStrategy = ConfigMappingInterface.getNamingStrategy(interfaceType);
    }

    public static ConfigMappingInterface getConfigurationInterface(Class<?> interfaceType) {
        Assert.checkNotNullParam((String)"interfaceType", interfaceType);
        return cv.get(interfaceType);
    }

    @Override
    public Class<?> getInterfaceType() {
        return this.interfaceType;
    }

    int getSuperTypeCount() {
        return this.superTypes.length;
    }

    ConfigMappingInterface[] getSuperTypes() {
        return this.superTypes;
    }

    ConfigMappingInterface getSuperType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.superTypes.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.superTypes[index];
    }

    public Property[] getProperties() {
        return this.properties;
    }

    int getPropertyCount() {
        return this.properties.length;
    }

    Property getProperty(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.properties.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.properties[index];
    }

    Property getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    String getClassInternalName() {
        return this.className.replace('.', '/');
    }

    List<ConfigMappingInterface> getNested() {
        ArrayList<ConfigMappingInterface> nested = new ArrayList<ConfigMappingInterface>();
        ConfigMappingInterface.getNested(this.properties, nested);
        return nested;
    }

    @Override
    public byte[] getClassBytes() {
        return ConfigMappingGenerator.generate(this);
    }

    private static ConfigMappingInterface createConfigurationInterface(Class<?> interfaceType) {
        if (!interfaceType.isInterface() || interfaceType.getTypeParameters().length != 0) {
            return null;
        }
        if (interfaceType.getName().startsWith("java")) {
            return null;
        }
        ConfigMappingInterface[] superTypes = ConfigMappingInterface.getSuperTypes(interfaceType.getInterfaces(), 0, 0);
        Property[] properties = ConfigMappingInterface.getProperties(interfaceType.getDeclaredMethods(), 0, 0);
        return new ConfigMappingInterface(interfaceType, superTypes, properties);
    }

    private static ConfigMappingInterface[] getSuperTypes(Class<?>[] interfaces, int si, int ti) {
        if (si == interfaces.length) {
            if (ti == 0) {
                return NO_TYPES;
            }
            return new ConfigMappingInterface[ti];
        }
        Class<?> item = interfaces[si];
        ConfigMappingInterface ci = ConfigMappingInterface.getConfigurationInterface(item);
        if (ci != null) {
            ConfigMappingInterface[] array = ConfigMappingInterface.getSuperTypes(interfaces, si + 1, ti + 1);
            array[ti] = ci;
            return array;
        }
        return ConfigMappingInterface.getSuperTypes(interfaces, si + 1, ti);
    }

    static Property[] getProperties(Method[] methods, int si, int ti) {
        if (si == methods.length) {
            if (ti == 0) {
                return NO_PROPERTIES;
            }
            return new Property[ti];
        }
        Method method = methods[si];
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods) || Modifier.isStatic(mods) || !Modifier.isAbstract(mods)) {
            return ConfigMappingInterface.getProperties(methods, si + 1, ti);
        }
        if (method.getParameterCount() > 0) {
            throw new IllegalArgumentException("Configuration methods cannot accept parameters");
        }
        if (method.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("Void config methods are not allowed");
        }
        Property p = ConfigMappingInterface.getPropertyDef(method, method.getGenericReturnType());
        Property[] array = ConfigMappingInterface.getProperties(methods, si + 1, ti + 1);
        array[ti] = p;
        return array;
    }

    private static Property getPropertyDef(Method method, Type type) {
        WithConverter withConverter;
        Method defaultMethod = ConfigMappingInterface.hasDefaultMethodImplementation(method);
        if (defaultMethod != null) {
            return new DefaultMethodProperty(method, defaultMethod, ConfigMappingInterface.getPropertyDef(defaultMethod, type));
        }
        Class<? extends Converter<?>> convertWith = ConfigMappingInterface.getConvertWith(type);
        if (convertWith == null && (withConverter = method.getAnnotation(WithConverter.class)) != null) {
            convertWith = withConverter.value();
        }
        String propertyName = ConfigMappingInterface.getPropertyName(method);
        Class<?> rawType = ConfigMappingInterface.rawTypeOf(type);
        if (rawType.isPrimitive()) {
            WithDefault annotation = method.getAnnotation(WithDefault.class);
            return new PrimitiveProperty(method, propertyName, rawType, convertWith, annotation == null ? null : annotation.value());
        }
        if (convertWith == null) {
            if (rawType == Optional.class) {
                Property nested = ConfigMappingInterface.getPropertyDef(method, ConfigMappingInterface.typeOfParameter(type, 0));
                if (nested.isMayBeOptional()) {
                    return new OptionalProperty(method, propertyName, nested.asMayBeOptional());
                }
                throw new IllegalArgumentException("Property type " + type + " cannot be optional");
            }
            if (rawType == Map.class) {
                Type keyType = ConfigMappingInterface.typeOfParameter(type, 0);
                Class<? extends Converter<?>> keyConvertWith = ConfigMappingInterface.getConvertWith(keyType);
                Type valueType = ConfigMappingInterface.typeOfParameter(type, 1);
                return new MapProperty(method, propertyName, keyType, keyConvertWith, ConfigMappingInterface.getPropertyDef(method, valueType));
            }
            if (rawType == List.class || rawType == Set.class) {
                Type elementType = ConfigMappingInterface.typeOfParameter(type, 0);
                if (ConfigMappingInterface.rawTypeOf(elementType) == Map.class) {
                    return new CollectionProperty(rawType, ConfigMappingInterface.getPropertyDef(method, elementType));
                }
                ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface((Class)elementType);
                if (configurationInterface != null) {
                    return new CollectionProperty(rawType, new GroupProperty(method, propertyName, configurationInterface));
                }
                WithDefault annotation = method.getAnnotation(WithDefault.class);
                return new CollectionProperty(rawType, new LeafProperty(method, propertyName, elementType, null, annotation == null ? null : annotation.value()));
            }
            ConfigMappingInterface configurationInterface = ConfigMappingInterface.getConfigurationInterface(rawType);
            if (configurationInterface != null) {
                return new GroupProperty(method, propertyName, configurationInterface);
            }
        }
        if (rawType == List.class || rawType == Set.class) {
            Type elementType = ConfigMappingInterface.typeOfParameter(type, 0);
            WithDefault annotation = method.getAnnotation(WithDefault.class);
            return new CollectionProperty(rawType, new LeafProperty(method, propertyName, elementType, convertWith, annotation == null ? null : annotation.value()));
        }
        WithDefault annotation = method.getAnnotation(WithDefault.class);
        return new LeafProperty(method, propertyName, type, convertWith, annotation == null ? null : annotation.value());
    }

    private static Method hasDefaultMethodImplementation(Method method) {
        Class<?>[] memberClasses;
        Class<?> methodClass = method.getDeclaringClass();
        for (Class<?> memberClass : memberClasses = methodClass.getClasses()) {
            Method candidateMethod;
            if (!memberClass.getSimpleName().equals("DefaultImpls")) continue;
            try {
                candidateMethod = memberClass.getMethod(method.getName(), methodClass);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (!candidateMethod.getReturnType().equals(method.getReturnType())) continue;
            return candidateMethod;
        }
        return null;
    }

    private static Class<? extends Converter<?>> getConvertWith(Type type) {
        if (type instanceof AnnotatedType) {
            WithConverter annotation = ((AnnotatedType)((Object)type)).getAnnotation(WithConverter.class);
            if (annotation != null) {
                return annotation.value();
            }
            return null;
        }
        return null;
    }

    private static String getPropertyName(AnnotatedElement element) {
        boolean useParent = element.getAnnotation(WithParentName.class) != null;
        WithName annotation = element.getAnnotation(WithName.class);
        if (annotation != null) {
            if (useParent) {
                throw new IllegalArgumentException("Cannot specify both @ParentConfigName and @ConfigName");
            }
            String name = annotation.value();
            if (!name.isEmpty()) {
                return name;
            }
            throw new IllegalArgumentException("Property name is empty");
        }
        if (useParent) {
            return "";
        }
        return null;
    }

    private static Map<String, Property> toPropertiesMap(Property[] properties) {
        HashMap<String, Property> map = new HashMap<String, Property>();
        for (Property p : properties) {
            map.put(p.getMethod().getName(), p);
        }
        return map;
    }

    private static void getNested(Property[] properties, List<ConfigMappingInterface> nested) {
        for (Property property : properties) {
            if (property instanceof GroupProperty) {
                GroupProperty groupProperty = (GroupProperty)property;
                ConfigMappingInterface group = groupProperty.getGroupType();
                nested.add(group);
                ConfigMappingInterface.getNested(group.properties, nested);
            }
            if (property instanceof OptionalProperty) {
                OptionalProperty optionalProperty = (OptionalProperty)property;
                if (optionalProperty.getNestedProperty() instanceof GroupProperty) {
                    GroupProperty groupProperty = (GroupProperty)optionalProperty.getNestedProperty();
                    ConfigMappingInterface group = groupProperty.getGroupType();
                    nested.add(group);
                    ConfigMappingInterface.getNested(group.properties, nested);
                } else if (optionalProperty.getNestedProperty() instanceof CollectionProperty) {
                    CollectionProperty collectionProperty = (CollectionProperty)optionalProperty.getNestedProperty();
                    ConfigMappingInterface.getNested(new Property[]{collectionProperty.element}, nested);
                }
            }
            if (property instanceof MapProperty) {
                MapProperty mapProperty = (MapProperty)property;
                ConfigMappingInterface.getNested(new Property[]{mapProperty.valueProperty}, nested);
            }
            if (!(property instanceof CollectionProperty)) continue;
            CollectionProperty collectionProperty = (CollectionProperty)property;
            ConfigMappingInterface.getNested(new Property[]{collectionProperty.element}, nested);
        }
    }

    static Type typeOfParameter(Type type, int index) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return null;
    }

    static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigMappingInterface.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigMappingInterface.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds != null) {
                return ConfigMappingInterface.rawTypeOf(upperBounds[0]);
            }
            return Object.class;
        }
        throw ConfigMessages.msg.noRawType(type);
    }

    private static NamingStrategy getNamingStrategy(Class<?> interfaceType) {
        ConfigMapping configMapping = interfaceType.getAnnotation(ConfigMapping.class);
        if (configMapping != null) {
            switch (configMapping.namingStrategy()) {
                case VERBATIM: {
                    return VERBATIM_NAMING_STRATEGY;
                }
                case KEBAB_CASE: {
                    return KEBAB_CASE_NAMING_STRATEGY;
                }
                case SNAKE_CASE: {
                    return SNAKE_CASE_NAMING_STRATEGY;
                }
            }
        }
        return DEFAULT_NAMING_STRATEGY;
    }

    static class SnakeNamingStrategy
    implements NamingStrategy {
        SnakeNamingStrategy() {
        }

        @Override
        public String apply(String s) {
            return StringUtil.skewer((String)s, (char)'_');
        }
    }

    static class KebabNamingStrategy
    implements NamingStrategy {
        KebabNamingStrategy() {
        }

        @Override
        public String apply(String s) {
            return StringUtil.skewer((String)s, (char)'-');
        }
    }

    static class VerbatimNamingStrategy
    implements NamingStrategy {
        VerbatimNamingStrategy() {
        }

        @Override
        public String apply(String s) {
            return s;
        }
    }

    public static interface NamingStrategy
    extends Function<String, String> {
        default public boolean isDefault() {
            return this.equals(DEFAULT_NAMING_STRATEGY);
        }
    }

    public static final class DefaultMethodProperty
    extends Property {
        private final Method defaultMethod;
        private final Property defaultProperty;

        DefaultMethodProperty(Method method, Method defaultMethod, Property defaultProperty) {
            super(method, "");
            this.defaultMethod = defaultMethod;
            this.defaultProperty = defaultProperty;
        }

        public Method getDefaultMethod() {
            return this.defaultMethod;
        }

        public Property getDefaultProperty() {
            return this.defaultProperty;
        }

        @Override
        public boolean isDefaultMethod() {
            return true;
        }

        @Override
        public DefaultMethodProperty asDefaultMethod() {
            return this;
        }
    }

    public static final class CollectionProperty
    extends MayBeOptionalProperty {
        private final Class<?> collectionRawType;
        private final Property element;

        CollectionProperty(Class<?> collectionType, Property element) {
            super(element.getMethod(), element.hasPropertyName() ? element.getPropertyName() : null);
            this.collectionRawType = collectionType;
            this.element = element;
        }

        public Class<?> getCollectionRawType() {
            return this.collectionRawType;
        }

        public Property getElement() {
            return this.element;
        }

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public CollectionProperty asCollection() {
            return this;
        }
    }

    public static final class MapProperty
    extends Property {
        private final Type keyType;
        private final Class<? extends Converter<?>> keyConvertWith;
        private final Property valueProperty;

        MapProperty(Method method, String propertyName, Type keyType, Class<? extends Converter<?>> keyConvertWith, Property valueProperty) {
            super(method, propertyName);
            this.keyType = keyType;
            this.keyConvertWith = keyConvertWith;
            this.valueProperty = valueProperty;
        }

        public Type getKeyType() {
            return this.keyType;
        }

        public Class<?> getKeyRawType() {
            return ConfigMappingInterface.rawTypeOf(this.keyType);
        }

        public Class<? extends Converter<?>> getKeyConvertWith() {
            return (Class)Assert.checkNotNullParam((String)"keyConvertWith", this.keyConvertWith);
        }

        public boolean hasKeyConvertWith() {
            return this.keyConvertWith != null;
        }

        public Property getValueProperty() {
            return this.valueProperty;
        }

        @Override
        public boolean isMap() {
            return true;
        }

        @Override
        public MapProperty asMap() {
            return this;
        }

        public int getLevels() {
            if (this.valueProperty.isMap()) {
                return this.valueProperty.asMap().getLevels() + 1;
            }
            return 1;
        }
    }

    public static final class LeafProperty
    extends MayBeOptionalProperty {
        private final Type valueType;
        private final Class<? extends Converter<?>> convertWith;
        private final Class<?> rawType;
        private final String defaultValue;

        LeafProperty(Method method, String propertyName, Type valueType, Class<? extends Converter<?>> convertWith, String defaultValue) {
            super(method, propertyName);
            this.valueType = valueType;
            this.convertWith = convertWith;
            this.rawType = ConfigMappingInterface.rawTypeOf(valueType);
            this.defaultValue = defaultValue;
        }

        public Type getValueType() {
            return this.valueType;
        }

        public Class<? extends Converter<?>> getConvertWith() {
            return this.convertWith;
        }

        public boolean hasConvertWith() {
            return this.convertWith != null;
        }

        public String getDefaultValue() {
            return (String)Assert.checkNotNullParam((String)"defaultValue", (Object)this.defaultValue);
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        public Class<?> getValueRawType() {
            return this.rawType;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public LeafProperty asLeaf() {
            return this;
        }
    }

    public static final class GroupProperty
    extends MayBeOptionalProperty {
        private final ConfigMappingInterface groupType;

        GroupProperty(Method method, String propertyName, ConfigMappingInterface groupType) {
            super(method, propertyName);
            this.groupType = groupType;
        }

        public ConfigMappingInterface getGroupType() {
            return this.groupType;
        }

        @Override
        public boolean isGroup() {
            return true;
        }

        @Override
        public GroupProperty asGroup() {
            return this;
        }
    }

    public static final class OptionalProperty
    extends Property {
        private final MayBeOptionalProperty nestedProperty;

        OptionalProperty(Method method, String propertyName, MayBeOptionalProperty nestedProperty) {
            super(method, propertyName);
            this.nestedProperty = nestedProperty;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public OptionalProperty asOptional() {
            return this;
        }

        @Override
        public boolean isLeaf() {
            return this.nestedProperty.isLeaf();
        }

        public MayBeOptionalProperty getNestedProperty() {
            return this.nestedProperty;
        }
    }

    public static final class PrimitiveProperty
    extends Property {
        private static final Map<Class<?>, Class<?>> boxTypes;
        private static final Map<Class<?>, String> unboxMethodName;
        private static final Map<Class<?>, String> unboxMethodDesc;
        private final Class<?> primitiveType;
        private final Class<? extends Converter<?>> convertWith;
        private final String defaultValue;

        PrimitiveProperty(Method method, String propertyName, Class<?> primitiveType, Class<? extends Converter<?>> convertWith, String defaultValue) {
            super(method, propertyName);
            this.primitiveType = primitiveType;
            this.convertWith = convertWith;
            this.defaultValue = defaultValue;
        }

        public Class<?> getPrimitiveType() {
            return this.primitiveType;
        }

        public Class<?> getBoxType() {
            return boxTypes.get(this.primitiveType);
        }

        public Class<? extends Converter<?>> getConvertWith() {
            return (Class)Assert.checkNotNullParam((String)"convertWith", this.convertWith);
        }

        public boolean hasConvertWith() {
            return this.convertWith != null;
        }

        public String getDefaultValue() {
            return (String)Assert.checkNotNullParam((String)"defaultValue", (Object)this.defaultValue);
        }

        public boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public PrimitiveProperty asPrimitive() {
            return this;
        }

        String getUnboxMethodName() {
            return unboxMethodName.get(this.primitiveType);
        }

        String getUnboxMethodDescriptor() {
            return unboxMethodDesc.get(this.primitiveType);
        }

        static {
            HashMap map = new HashMap();
            map.put(Byte.TYPE, Byte.class);
            map.put(Short.TYPE, Short.class);
            map.put(Integer.TYPE, Integer.class);
            map.put(Long.TYPE, Long.class);
            map.put(Float.TYPE, Float.class);
            map.put(Double.TYPE, Double.class);
            map.put(Boolean.TYPE, Boolean.class);
            map.put(Character.TYPE, Character.class);
            boxTypes = map;
            HashMap<Class<Object>, String> nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "byteValue");
            nameMap.put(Short.TYPE, "shortValue");
            nameMap.put(Integer.TYPE, "intValue");
            nameMap.put(Long.TYPE, "longValue");
            nameMap.put(Float.TYPE, "floatValue");
            nameMap.put(Double.TYPE, "doubleValue");
            nameMap.put(Boolean.TYPE, "booleanValue");
            nameMap.put(Character.TYPE, "charValue");
            unboxMethodName = nameMap;
            nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "()B");
            nameMap.put(Short.TYPE, "()S");
            nameMap.put(Integer.TYPE, "()I");
            nameMap.put(Long.TYPE, "()J");
            nameMap.put(Float.TYPE, "()F");
            nameMap.put(Double.TYPE, "()D");
            nameMap.put(Boolean.TYPE, "()Z");
            nameMap.put(Character.TYPE, "()C");
            unboxMethodDesc = nameMap;
            nameMap = new HashMap();
            nameMap.put(Byte.TYPE, "B");
            nameMap.put(Short.TYPE, "S");
            nameMap.put(Integer.TYPE, "I");
            nameMap.put(Long.TYPE, "J");
            nameMap.put(Float.TYPE, "F");
            nameMap.put(Double.TYPE, "D");
            nameMap.put(Boolean.TYPE, "Z");
            nameMap.put(Character.TYPE, "C");
        }
    }

    public static abstract class MayBeOptionalProperty
    extends Property {
        MayBeOptionalProperty(Method method, String propertyName) {
            super(method, propertyName);
        }

        @Override
        public boolean isMayBeOptional() {
            return true;
        }

        @Override
        public MayBeOptionalProperty asMayBeOptional() {
            return this;
        }
    }

    public static abstract class Property {
        private final Method method;
        private final String propertyName;

        Property(Method method, String propertyName) {
            this.method = method;
            this.propertyName = propertyName;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getPropertyName() {
            if (this.isParentPropertyName()) {
                return this.propertyName;
            }
            return this.hasPropertyName() && !this.propertyName.isEmpty() ? this.propertyName : this.method.getName();
        }

        public boolean hasPropertyName() {
            return this.propertyName != null;
        }

        public boolean isParentPropertyName() {
            return this.hasPropertyName() && this.propertyName.isEmpty();
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isOptional() {
            return false;
        }

        public boolean isGroup() {
            return false;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean isMap() {
            return false;
        }

        public boolean isMayBeOptional() {
            return false;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isDefaultMethod() {
            return false;
        }

        public PrimitiveProperty asPrimitive() {
            throw new ClassCastException();
        }

        public OptionalProperty asOptional() {
            throw new ClassCastException();
        }

        public GroupProperty asGroup() {
            throw new ClassCastException();
        }

        public LeafProperty asLeaf() {
            throw new ClassCastException();
        }

        public MapProperty asMap() {
            throw new ClassCastException();
        }

        public MayBeOptionalProperty asMayBeOptional() {
            throw new ClassCastException();
        }

        public CollectionProperty asCollection() {
            throw new ClassCastException();
        }

        public DefaultMethodProperty asDefaultMethod() {
            throw new ClassCastException();
        }
    }
}

