/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.exporter.jaeger.proto.api_v2.internal.SpanRef;
import io.opentelemetry.exporter.jaeger.proto.api_v2.internal.SpanRefType;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoEnumInfo;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class SpanRefMarshaler
extends MarshalerWithSize {
    private final String traceId;
    private final String spanId;
    private final ProtoEnumInfo refType;

    static List<SpanRefMarshaler> createRepeated(List<LinkData> links) {
        ArrayList<SpanRefMarshaler> marshalers = new ArrayList<SpanRefMarshaler>(links.size());
        for (LinkData link : links) {
            marshalers.add(SpanRefMarshaler.create(link));
        }
        return marshalers;
    }

    static SpanRefMarshaler create(SpanContext spanContext) {
        return new SpanRefMarshaler(spanContext.getTraceId(), spanContext.getSpanId(), SpanRefType.CHILD_OF);
    }

    static SpanRefMarshaler create(LinkData link) {
        return new SpanRefMarshaler(link.getSpanContext().getTraceId(), link.getSpanContext().getSpanId(), SpanRefType.FOLLOWS_FROM);
    }

    SpanRefMarshaler(String traceId, String spanId, ProtoEnumInfo refType) {
        super(SpanRefMarshaler.calculateSize(traceId, spanId, refType));
        this.traceId = traceId;
        this.spanId = spanId;
        this.refType = refType;
    }

    protected void writeTo(Serializer output) throws IOException {
        output.serializeTraceId(SpanRef.TRACE_ID, this.traceId);
        output.serializeSpanId(SpanRef.SPAN_ID, this.spanId);
        output.serializeEnum(SpanRef.REF_TYPE, this.refType);
    }

    private static int calculateSize(String traceId, String spanId, ProtoEnumInfo refType) {
        int size = 0;
        size += MarshalerUtil.sizeTraceId((ProtoFieldInfo)SpanRef.TRACE_ID, (String)traceId);
        size += MarshalerUtil.sizeSpanId((ProtoFieldInfo)SpanRef.SPAN_ID, (String)spanId);
        return size += MarshalerUtil.sizeEnum((ProtoFieldInfo)SpanRef.REF_TYPE, (ProtoEnumInfo)refType);
    }
}

