/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Average;
import org.jgroups.util.MessageBatch;

@MBean(description="Measures latency between PERF instances")
public class PERF
extends Protocol {
    protected Average avg;
    protected Address local_addr;
    @Property(description="Number of samples to maintain for rolling average")
    protected int avg_size = 20;

    @ManagedAttribute(description="Average latency in ns")
    public double latencyInNs() {
        return this.avg.getAverage();
    }

    @ManagedAttribute(description="Average latency in ms")
    public double latencyInMs() {
        return this.avg.getAverage() / 1000000.0;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.avg = new Average();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.avg.clear();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        msg.putHeader(this.id, new PerfHeader(System.nanoTime()));
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Message msg) {
        PerfHeader hdr = (PerfHeader)msg.getHeader(this.id);
        if (hdr == null) {
            this.log.error("%s: no perf header found", this.local_addr);
        } else {
            long time = System.nanoTime() - hdr.start_time;
            if (time <= 0L) {
                this.log.error("%d: time is <= 0", time);
            } else {
                this.avg.add(time);
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            PerfHeader hdr = (PerfHeader)msg.getHeader(this.id);
            if (hdr == null) {
                this.log.error("%s: no perf header found", this.local_addr);
                continue;
            }
            long time = System.nanoTime() - hdr.start_time;
            if (time <= 0L) {
                this.log.error("%d: time is <= 0", time);
                continue;
            }
            this.avg.add(time);
        }
        super.up(batch);
    }

    protected static class PerfHeader
    extends Header {
        protected long start_time;

        public PerfHeader() {
        }

        public PerfHeader(long start_time) {
            this.start_time = start_time;
        }

        @Override
        public short getMagicId() {
            return 84;
        }

        @Override
        public Supplier<? extends Header> create() {
            return PerfHeader::new;
        }

        @Override
        public int serializedSize() {
            return 8;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeLong(this.start_time);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.start_time = in.readLong();
        }
    }
}

