/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.metrics;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.MarshalerUtil;
import io.opentelemetry.exporter.otlp.internal.MarshalerWithSize;
import io.opentelemetry.exporter.otlp.internal.ProtoEnumInfo;
import io.opentelemetry.exporter.otlp.internal.ProtoFieldInfo;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import io.opentelemetry.exporter.otlp.internal.metrics.HistogramDataPointMarshaler;
import io.opentelemetry.exporter.otlp.internal.metrics.MetricsMarshalerUtil;
import io.opentelemetry.proto.metrics.v1.internal.Histogram;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import java.io.IOException;

final class HistogramMarshaler
extends MarshalerWithSize {
    private final HistogramDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;

    static HistogramMarshaler create(DoubleHistogramData histogram) {
        HistogramDataPointMarshaler[] dataPointMarshalers = HistogramDataPointMarshaler.createRepeated(histogram.getPoints());
        return new HistogramMarshaler(dataPointMarshalers, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }

    private HistogramMarshaler(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        super(HistogramMarshaler.calculateSize(dataPoints, aggregationTemporality));
        this.dataPoints = dataPoints;
        this.aggregationTemporality = aggregationTemporality;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Histogram.DATA_POINTS, this.dataPoints);
        output.serializeEnum(Histogram.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
    }

    private static int calculateSize(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Histogram.DATA_POINTS, (Marshaler[])dataPoints);
        return size += MarshalerUtil.sizeEnum(Histogram.AGGREGATION_TEMPORALITY, aggregationTemporality);
    }
}

