/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

final class GrpcRequestBody
extends RequestBody {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED_FLAG = 0;
    private static final byte COMPRESSED_FLAG = 1;
    private static final MediaType GRPC_MEDIA_TYPE = MediaType.parse((String)"application/grpc");
    private final Marshaler marshaler;
    private final int messageSize;
    private final int contentLength;
    private final boolean compressed;

    GrpcRequestBody(Marshaler marshaler, boolean compressed) {
        this.marshaler = marshaler;
        this.compressed = compressed;
        this.messageSize = marshaler.getBinarySerializedSize();
        this.contentLength = compressed ? -1 : 5 + this.messageSize;
    }

    @Nullable
    public MediaType contentType() {
        return GRPC_MEDIA_TYPE;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (!this.compressed) {
            sink.writeByte(0);
            sink.writeInt(this.messageSize);
            this.marshaler.writeBinaryTo(sink.outputStream());
        } else {
            try (Buffer compressedBody = new Buffer();){
                try (BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)compressedBody));){
                    this.marshaler.writeBinaryTo(gzipSink.outputStream());
                }
                sink.writeByte(1);
                int compressedBytes = (int)compressedBody.size();
                sink.writeInt(compressedBytes);
                sink.write(compressedBody, (long)compressedBytes);
            }
        }
    }
}

