/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal.grpc;

import io.grpc.ClientInterceptor;
import io.grpc.Codec;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.RetryPolicy;
import io.opentelemetry.exporter.otlp.internal.grpc.DefaultGrpcExporter;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.grpc.ManagedChannelUtil;
import io.opentelemetry.exporter.otlp.internal.grpc.MarshalerServiceStub;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class DefaultGrpcExporterBuilder<T extends Marshaler>
implements GrpcExporterBuilder<T> {
    private final String type;
    private final Function<ManagedChannel, MarshalerServiceStub<T, ?, ?>> stubFactory;
    private final String grpcServiceName;
    @Nullable
    private ManagedChannel channel;
    private long timeoutNanos;
    private URI endpoint;
    private boolean compressionEnabled = false;
    @Nullable
    private Metadata metadata;
    @Nullable
    private byte[] trustedCertificatesPem;
    @Nullable
    private RetryPolicy retryPolicy;

    public DefaultGrpcExporterBuilder(String type, Function<ManagedChannel, MarshalerServiceStub<T, ?, ?>> stubFactory, long defaultTimeoutSecs, URI defaultEndpoint, String grpcServiceName) {
        this.type = type;
        this.stubFactory = stubFactory;
        this.grpcServiceName = grpcServiceName;
        this.timeoutNanos = TimeUnit.SECONDS.toNanos(defaultTimeoutSecs);
        this.endpoint = defaultEndpoint;
    }

    @Override
    public DefaultGrpcExporterBuilder<T> setChannel(ManagedChannel channel) {
        this.channel = channel;
        return this;
    }

    @Override
    public DefaultGrpcExporterBuilder<T> setTimeout(long timeout, TimeUnit unit) {
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    @Override
    public DefaultGrpcExporterBuilder<T> setTimeout(Duration timeout) {
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public DefaultGrpcExporterBuilder<T> setEndpoint(String endpoint) {
        URI uri;
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint, must be a URL: " + endpoint, e);
        }
        if (uri.getScheme() == null || !uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
            throw new IllegalArgumentException("Invalid endpoint, must start with http:// or https://: " + uri);
        }
        this.endpoint = uri;
        return this;
    }

    @Override
    public DefaultGrpcExporterBuilder<T> setCompression(String compressionMethod) {
        this.compressionEnabled = true;
        return this;
    }

    @Override
    public DefaultGrpcExporterBuilder<T> setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.trustedCertificatesPem = trustedCertificatesPem;
        return this;
    }

    @Override
    public DefaultGrpcExporterBuilder<T> addHeader(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        this.metadata.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
        return this;
    }

    @Override
    public GrpcExporterBuilder<T> addRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public GrpcExporter<T> build() {
        ManagedChannel channel = this.channel;
        if (channel == null) {
            ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint.getAuthority());
            if (this.endpoint.getScheme().equals("https")) {
                managedChannelBuilder.useTransportSecurity();
            } else {
                managedChannelBuilder.usePlaintext();
            }
            if (this.metadata != null) {
                managedChannelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)});
            }
            if (this.trustedCertificatesPem != null) {
                try {
                    ManagedChannelUtil.setTrustedCertificatesPem(managedChannelBuilder, this.trustedCertificatesPem);
                }
                catch (SSLException e) {
                    throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                }
            }
            if (this.retryPolicy != null) {
                managedChannelBuilder.defaultServiceConfig(ManagedChannelUtil.toServiceConfig(this.grpcServiceName, this.retryPolicy));
            }
            channel = managedChannelBuilder.build();
        }
        Codec codec = this.compressionEnabled ? new Codec.Gzip() : Codec.Identity.NONE;
        MarshalerServiceStub stub = (MarshalerServiceStub)this.stubFactory.apply(channel).withCompression(codec.getMessageEncoding());
        return new DefaultGrpcExporter(this.type, channel, stub, this.timeoutNanos, this.compressionEnabled);
    }

    public static <T> DefaultGrpcExporterBuilder<?> getDelegateBuilder(Class<T> type, T instance) {
        try {
            Field field = type.getDeclaredField("delegate");
            field.setAccessible(true);
            Object value = field.get(instance);
            if (!(value instanceof DefaultGrpcExporterBuilder)) {
                throw new IllegalArgumentException("delegate field is not type DefaultGrpcExporterBuilder");
            }
            return (DefaultGrpcExporterBuilder)value;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Unable to access delegate reflectively.", e);
        }
    }
}

