/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AmqpReadableBuffer
implements ReadableBuffer {
    private ByteBuffer buffer;

    public AmqpReadableBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        if (this.buffer.hasArray()) {
            return this.buffer.array();
        }
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.get(bytes);
        return bytes;
    }

    public void freeDirectBuffer() {
        PlatformDependent.freeDirectBuffer((ByteBuffer)this.buffer);
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public ReadableBuffer reclaimRead() {
        return this;
    }

    public byte get() {
        return this.buffer.get();
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public ReadableBuffer get(byte[] target, int offset, int length) {
        this.buffer.get(target, offset, length);
        return this;
    }

    public ReadableBuffer get(byte[] target) {
        this.buffer.get(target);
        return this;
    }

    public ReadableBuffer get(WritableBuffer target) {
        int start = target.position();
        if (this.buffer.hasArray()) {
            target.put(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining());
        } else {
            target.put(this.buffer);
        }
        int written = target.position() - start;
        this.buffer.position(this.buffer.position() + written);
        return this;
    }

    public ReadableBuffer slice() {
        return new AmqpReadableBuffer(this.buffer.slice());
    }

    public ReadableBuffer flip() {
        this.buffer.flip();
        return this;
    }

    public ReadableBuffer limit(int limit) {
        this.buffer.limit(limit);
        return this;
    }

    public int limit() {
        return this.buffer.limit();
    }

    public ReadableBuffer position(int position) {
        this.buffer.position(position);
        return this;
    }

    public int position() {
        return this.buffer.position();
    }

    public ReadableBuffer mark() {
        this.buffer.mark();
        return this;
    }

    public ReadableBuffer reset() {
        this.buffer.reset();
        return this;
    }

    public ReadableBuffer rewind() {
        this.buffer.rewind();
        return this;
    }

    public ReadableBuffer clear() {
        this.buffer.clear();
        return this;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public ReadableBuffer duplicate() {
        return new AmqpReadableBuffer(this.buffer.duplicate());
    }

    public ByteBuffer byteBuffer() {
        return this.buffer;
    }

    public String readUTF8() throws CharacterCodingException {
        ByteBuf wrappedNetty = Unpooled.wrappedBuffer((ByteBuffer)this.buffer);
        return wrappedNetty.toString(StandardCharsets.UTF_8);
    }

    public String readString(CharsetDecoder decoder) throws CharacterCodingException {
        ByteBuf wrappedNetty = Unpooled.wrappedBuffer((ByteBuffer)this.buffer);
        return wrappedNetty.toString(StandardCharsets.UTF_8);
    }
}

