/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.LivePageCache;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.utils.collections.ConcurrentAppendOnlyChunkedList;
import org.jboss.logging.Logger;

public final class LivePageCacheImpl
implements LivePageCache {
    private static final Logger logger = Logger.getLogger(LivePageCacheImpl.class);
    private static final int CHUNK_SIZE = 32;
    private final PagedMessage[] initialMessages;
    private final ConcurrentAppendOnlyChunkedList<PagedMessage> liveMessages;
    private final long pageId;
    private volatile boolean isLive = true;

    public LivePageCacheImpl(long pageId) {
        this.pageId = pageId;
        this.liveMessages = new ConcurrentAppendOnlyChunkedList(32);
        this.initialMessages = null;
    }

    public LivePageCacheImpl(long pageId, PagedMessage[] initialMessages) {
        this.pageId = pageId;
        this.liveMessages = new ConcurrentAppendOnlyChunkedList(32);
        this.initialMessages = initialMessages;
    }

    private int initialMessagesSize() {
        PagedMessage[] initialMessages = this.initialMessages;
        return initialMessages == null ? 0 : initialMessages.length;
    }

    @Override
    public long getPageId() {
        return this.pageId;
    }

    @Override
    public int getNumberOfMessages() {
        return this.initialMessagesSize() + this.liveMessages.size();
    }

    @Override
    public PagedMessage getMessage(PagePosition pagePosition) {
        int messageNr = pagePosition.getMessageNr();
        if (messageNr < 0) {
            return null;
        }
        int initialOffset = this.initialMessagesSize();
        if (messageNr < initialOffset) {
            return this.initialMessages[messageNr];
        }
        int index = messageNr - initialOffset;
        return (PagedMessage)this.liveMessages.get(index);
    }

    public boolean isLive() {
        return this.isLive;
    }

    @Override
    public void addLiveMessage(PagedMessage message) {
        message.getMessage().usageUp();
        this.liveMessages.add((Object)message);
    }

    @Override
    public void close() {
        logger.tracef("Closing %s", (Object)this);
        this.isLive = false;
    }

    @Override
    public PagedMessage[] getMessages() {
        PagedMessage[] pagedMessages = (PagedMessage[])this.liveMessages.toArray(size -> new PagedMessage[this.initialMessagesSize() + size], this.initialMessagesSize());
        PagedMessage[] initialMessages = this.initialMessages;
        if (initialMessages != null) {
            System.arraycopy(initialMessages, 0, pagedMessages, 0, initialMessages.length);
        }
        return pagedMessages;
    }

    public String toString() {
        return "LivePacheCacheImpl::page=" + this.pageId + " number of messages=" + this.getNumberOfMessages() + " isLive = " + this.isLive;
    }
}

