/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.AddressField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.AddressFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.utils.JsonLoader;

public class AddressView
extends ActiveMQAbstractView<AddressInfo> {
    private static final String defaultSortColumn = AddressField.ID.getName();
    private final ActiveMQServer server;

    public AddressView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new AddressFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return AddressInfo.class;
    }

    @Override
    public JsonObjectBuilder toJson(AddressInfo address) {
        if (address == null) {
            return null;
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(AddressField.ID.getName(), this.toString(address.getId())).add(AddressField.NAME.getName(), this.toString(address.getName())).add(AddressField.ROUTING_TYPES.getName(), this.toString(address.getRoutingTypes()));
        try {
            obj.add(AddressField.QUEUE_COUNT.getName(), this.toString(this.server.bindingQuery(address.getName()).getQueueNames().size()));
            return obj;
        }
        catch (Exception e) {
            obj.add(AddressField.QUEUE_COUNT.getName(), 0);
            return obj;
        }
    }

    @Override
    public Object getField(AddressInfo address, String fieldName) {
        if (address == null) {
            return null;
        }
        AddressField field = AddressField.valueOfName(fieldName);
        switch (field) {
            case ID: {
                return address.getId();
            }
            case NAME: {
                return address.getName();
            }
            case ROUTING_TYPES: {
                return address.getRoutingTypes();
            }
            case QUEUE_COUNT: {
                try {
                    return this.server.bindingQuery(address.getName()).getQueueNames().size();
                }
                catch (Exception e) {
                    return 0;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

