/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WriteVersionTo {
    public static void main(String[] args) throws IOException {
        String pom = "pom.xml";
        String input = "./conf/JGROUPS_VERSION.properties";
        String output = "./classes/JGROUPS_VERSION.properties";
        String jgroups_version = "jgroups.version";
        String jgroups_codename = "jgroups.codename";
        block23: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-pom": {
                    pom = args[++i];
                    continue block23;
                }
                case "-input": {
                    input = args[++i];
                    continue block23;
                }
                case "-output": {
                    output = args[++i];
                    continue block23;
                }
                case "-version": {
                    jgroups_version = args[++i];
                    continue block23;
                }
                case "-codename": {
                    jgroups_codename = args[++i];
                    continue block23;
                }
                default: {
                    System.out.printf("%s [-pom POM] [-input <input file>] [-output <output file>] [-version <version name>] [-codename <codename>]\n", WriteVersionTo.class.getSimpleName());
                    return;
                }
            }
        }
        InputStream in = Util.getResourceAsStream(input, (ClassLoader)null);
        if (in == null) {
            in = new FileInputStream(input);
        }
        if (in == null) {
            throw new FileNotFoundException(input);
        }
        Properties props = new Properties();
        props.load(in);
        String[] result = WriteVersionTo.parseVersionAndCodenameFromPOM(pom);
        String version = result[0];
        String codename = result[1];
        props.replace(jgroups_version, version);
        props.replace(jgroups_codename, codename);
        System.out.println("props = " + props);
        try (FileOutputStream out = new FileOutputStream(output);){
            props.store(out, "Generated by " + WriteVersionTo.class.getSimpleName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] parseVersionAndCodenameFromPOM(String pom) throws IOException {
        try (FileInputStream in = new FileInputStream(pom);){
            if (in == null) {
                throw new FileNotFoundException(pom);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            final AtomicReference ex = new AtomicReference();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    System.err.printf(Util.getMessage("ParseFailure"), e);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    ex.set(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    ex.set(exception);
                }
            });
            Document document = builder.parse(in);
            if (ex.get() != null) {
                throw (SAXParseException)ex.get();
            }
            Element root_element = document.getDocumentElement();
            String root_name = root_element.getNodeName().trim().toLowerCase();
            if (!"project".equals(root_name)) {
                throw new IOException("the POM does not start with a <project> element: " + root_name);
            }
            String version = Util.getChild(root_element, "version");
            String codename = Util.getChild(root_element, "properties.codename");
            String[] stringArray = new String[]{version, codename};
            return stringArray;
        }
        catch (Exception x) {
            throw new IOException(String.format(Util.getMessage("ParseError"), x));
        }
    }
}

