/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Supplier;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.keystore.ElytronMessages;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.pem.PemEntry;
import org.wildfly.security.provider.util.ProviderUtil;

public class KeyStoreUtil {
    private static final String BCFKS = "BCFKS";
    private static final String BKS = "BKS";
    private static final String JCEKS = "JCEKS";
    private static final String JKS = "JKS";
    private static final String PKCS12 = "PKCS12";
    private static final String UBER = "UBER";
    private static final int VERSION_0 = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int JCEKS_MAGIC = -825307442;
    private static final int JKS_MAGIC = -17957139;
    private static final int SEQUENCE = 0x30000000;
    private static final int PEM_MAGIC = 0x2D2D2D2D;

    public static KeyStore loadKeyStore(Supplier<Provider[]> providers, String providerName, FileInputStream is, String filename, char[] password) throws IOException, KeyStoreException {
        ResettableDataFileInputStream dis = new ResettableDataFileInputStream(is);
        int firstInt = dis.readInt();
        ((FilterInputStream)dis).reset();
        KeyStore result = null;
        if (firstInt == -17957139) {
            result = KeyStoreUtil.tryLoadKeystore(providers, providerName, dis, password, JKS);
        } else if (firstInt == -825307442) {
            result = KeyStoreUtil.tryLoadKeystore(providers, providerName, dis, password, JCEKS);
        } else if (firstInt == 1 || firstInt == 2) {
            ((FilterInputStream)dis).reset();
            ((FilterInputStream)dis).skip(32L);
            byte firstElementType = dis.readByte();
            ((FilterInputStream)dis).reset();
            result = firstElementType <= 5 ? KeyStoreUtil.tryLoadKeystore(providers, providerName, dis, password, BKS, UBER) : KeyStoreUtil.tryLoadKeystore(providers, providerName, dis, password, UBER, BKS);
        } else if (firstInt == 0) {
            result = KeyStoreUtil.tryLoadKeystore(providers, providerName, dis, password, UBER);
        } else if ((firstInt & 0xFF000000) == 0x30000000) {
            String[] parts = filename.split("\\.");
            String extension = parts[parts.length - 1];
            result = extension.startsWith("b") || extension.startsWith("B") ? KeyStoreUtil.tryLoadKeystore(providers, providerName, dis, password, BCFKS, PKCS12) : KeyStoreUtil.tryLoadKeystore(providers, providerName, dis, password, PKCS12, BCFKS);
        } else if (firstInt == 0x2D2D2D2D) {
            result = KeyStoreUtil.loadPemAsKeyStore(is, password);
        }
        if (result == null) {
            throw ElytronMessages.log.keyStoreTypeNotDetected();
        }
        return result;
    }

    private static KeyStore tryLoadKeystore(Supplier<Provider[]> providers, String providerName, InputStream is, char[] password, String ... types) {
        for (String type : types) {
            try {
                ElytronMessages.log.debug("Searching provider for: " + type);
                Provider provider = ProviderUtil.findProvider(providers, providerName, KeyStore.class, type);
                if (provider != null) {
                    ElytronMessages.log.debug("Provider found: " + provider.getName());
                    KeyStore keystore = KeyStore.getInstance(type, provider);
                    is.reset();
                    keystore.load(is, password);
                    return keystore;
                }
                ElytronMessages.log.debug("Provider not found");
            }
            catch (Exception e) {
                ElytronMessages.log.debug("KeyStore is not of type " + type);
            }
        }
        return null;
    }

    private static KeyStore loadPemAsKeyStore(FileInputStream is, char[] password) throws KeyStoreException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            keyStore.load(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PrivateKey pk = null;
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        byte[] pem = new byte[(int)is.getChannel().size()];
        is.read(pem);
        Iterator<PemEntry<?>> it = Pem.parsePemContent(CodePointIterator.ofUtf8Bytes(pem));
        while (it.hasNext()) {
            Object entry = it.next().getEntry();
            if (entry instanceof PrivateKey) {
                pk = (PrivateKey)entry;
                continue;
            }
            if (!(entry instanceof Certificate)) continue;
            Certificate certificate = (Certificate)entry;
            certificates.add(certificate);
        }
        if (pk != null) {
            Certificate certificate = (Certificate)certificates.get(0);
            String alias = certificate instanceof X509Certificate ? ((X509Certificate)certificate).getSubjectX500Principal().getName() : "key";
            keyStore.setKeyEntry(alias, pk, password, certificates.toArray(new Certificate[0]));
        } else {
            int i = 1;
            for (Certificate certificate : certificates) {
                String alias = certificate instanceof X509Certificate ? ((X509Certificate)certificate).getSubjectX500Principal().getName() : Integer.toString(i++);
                keyStore.setCertificateEntry(alias, certificate);
            }
        }
        return keyStore;
    }

    private static class ResettableDataFileInputStream
    extends DataInputStream {
        private FileChannel fc;
        private long startingPosition = 0L;

        public ResettableDataFileInputStream(FileInputStream is) {
            super(is);
            this.fc = is.getChannel();
            try {
                this.startingPosition = this.fc.position();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void reset() throws IOException {
            this.fc.position(this.startingPosition);
        }

        @Override
        public long skip(long bytes) throws IOException {
            this.fc.position(this.fc.position() + bytes);
            return 0L;
        }
    }
}

