/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.Map;
import java.util.function.Function;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocatorConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;

public class PrimaryOwnerRouteLocator
implements RouteLocator {
    private final Function<GroupedKey<String>, Node> primaryOwnerLocator;
    private final Registry<String, Void> registry;
    private final String localRoute;

    public PrimaryOwnerRouteLocator(PrimaryOwnerRouteLocatorConfiguration config) {
        this((Function<GroupedKey<String>, Node>)new PrimaryOwnerLocator(config.getCache(), config.getMemberFactory()), config.getRegistry());
    }

    PrimaryOwnerRouteLocator(Function<GroupedKey<String>, Node> primaryOwnerLocator, Registry<String, Void> registry) {
        this.primaryOwnerLocator = primaryOwnerLocator;
        this.registry = registry;
        this.localRoute = (String)this.registry.getEntry(this.registry.getGroup().getLocalMember()).getKey();
    }

    public String locate(String sessionId) {
        Node primaryMember = this.primaryOwnerLocator.apply((GroupedKey<String>)new GroupedKey((Object)sessionId));
        Map.Entry entry = this.registry.getEntry(primaryMember);
        return entry != null ? (String)entry.getKey() : this.localRoute;
    }
}

