/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.util.impl.Closeables;

public class MutableAnalyzerRegistry
implements AnalyzerRegistry {
    private final AnalyzerStrategy strategy;
    private final AnalyzerReference defaultReference;
    private final AnalyzerReference passThroughReference;
    private final Map<String, AnalyzerReference> referencesByName = new LinkedHashMap<String, AnalyzerReference>();
    private final Map<Class<?>, AnalyzerReference> referencesByLuceneClass = new LinkedHashMap();
    private final Collection<AnalyzerReference> scopedReferences = new ArrayList<AnalyzerReference>();

    MutableAnalyzerRegistry(AnalyzerStrategy strategy, AnalyzerRegistry registryState) {
        this.strategy = strategy;
        if (registryState != null) {
            this.defaultReference = registryState.getDefaultAnalyzerReference();
            this.passThroughReference = registryState.getPassThroughAnalyzerReference();
            this.referencesByName.putAll(strategy.createProvidedAnalyzerReferences());
            this.referencesByName.putAll(registryState.getNamedAnalyzerReferences());
            this.referencesByLuceneClass.putAll(registryState.getLuceneClassAnalyzerReferences());
        } else {
            this.defaultReference = strategy.createDefaultAnalyzerReference();
            this.passThroughReference = strategy.createPassThroughAnalyzerReference();
            this.referencesByName.putAll(strategy.createProvidedAnalyzerReferences());
        }
    }

    @Override
    public AnalyzerReference getDefaultAnalyzerReference() {
        return this.defaultReference;
    }

    @Override
    public AnalyzerReference getPassThroughAnalyzerReference() {
        return this.passThroughReference;
    }

    @Override
    public Map<String, AnalyzerReference> getNamedAnalyzerReferences() {
        return Collections.unmodifiableMap(this.referencesByName);
    }

    @Override
    public Map<Class<?>, AnalyzerReference> getLuceneClassAnalyzerReferences() {
        return Collections.unmodifiableMap(this.referencesByLuceneClass);
    }

    @Override
    public Collection<AnalyzerReference> getScopedAnalyzerReferences() {
        return Collections.unmodifiableCollection(this.scopedReferences);
    }

    @Override
    public AnalyzerReference getAnalyzerReference(String name) {
        return this.referencesByName.get(name);
    }

    public AnalyzerReference getOrCreateAnalyzerReference(String name) {
        AnalyzerReference reference = this.referencesByName.get(name);
        if (reference == null) {
            reference = this.strategy.createNamedAnalyzerReference(name);
            this.referencesByName.put(name, reference);
        }
        return reference;
    }

    @Override
    public AnalyzerReference getAnalyzerReference(Class<?> analyzerClazz) {
        return this.referencesByLuceneClass.get(analyzerClazz);
    }

    public AnalyzerReference getOrCreateAnalyzerReference(Class<?> analyzerClazz) {
        AnalyzerReference reference = this.referencesByLuceneClass.get(analyzerClazz);
        if (reference == null) {
            reference = this.strategy.createLuceneClassAnalyzerReference(analyzerClazz);
            this.referencesByLuceneClass.put(analyzerClazz, reference);
        }
        return reference;
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.getAllReferences());
    }

    public ScopedAnalyzerReference.Builder buildScopedAnalyzerReference() {
        return new ScopedAnalyzerReferenceBuilderRegisteringWrapper(this.strategy.buildScopedAnalyzerReference(this.getDefaultAnalyzerReference()));
    }

    public List<AnalyzerReference> getAllReferences() {
        ArrayList<AnalyzerReference> references = new ArrayList<AnalyzerReference>();
        references.add(this.defaultReference);
        references.add(this.passThroughReference);
        references.addAll(this.referencesByName.values());
        references.addAll(this.referencesByLuceneClass.values());
        references.addAll(this.scopedReferences);
        return references;
    }

    private class ScopedAnalyzerReferenceBuilderRegisteringWrapper
    implements ScopedAnalyzerReference.Builder {
        private final ScopedAnalyzerReference.Builder delegate;

        public ScopedAnalyzerReferenceBuilderRegisteringWrapper(ScopedAnalyzerReference.Builder delegate) {
            this.delegate = delegate;
        }

        @Override
        public AnalyzerReference getGlobalAnalyzerReference() {
            return this.delegate.getGlobalAnalyzerReference();
        }

        @Override
        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.delegate.setGlobalAnalyzerReference(globalAnalyzerReference);
        }

        @Override
        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.delegate.addAnalyzerReference(scope, analyzerReference);
        }

        @Override
        public ScopedAnalyzerReference build() {
            ScopedAnalyzerReference reference = this.delegate.build();
            MutableAnalyzerRegistry.this.scopedReferences.add(reference);
            return reference;
        }
    }
}

