/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.security.SecurityDomainInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.wildfly.security.auth.server.SecurityDomain;

public class SecurityDomainInterceptorFactory
extends ComponentInterceptorFactory {
    public static final InterceptorFactory INSTANCE = new SecurityDomainInterceptorFactory();
    private static final String DEFAULT_DOMAIN = "other";

    protected Interceptor create(Component component, InterceptorFactoryContext context) {
        SecurityDomain securityDomain;
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        EJBSecurityMetaData securityMetaData = ejbComponent.getSecurityMetaData();
        String securityDomainName = securityMetaData.getSecurityDomainName();
        if (securityDomainName == null) {
            securityDomainName = DEFAULT_DOMAIN;
        }
        if ((securityDomain = ejbComponent.getSecurityDomain()) == null) {
            throw EjbLogger.ROOT_LOGGER.invalidSecurityForDomainSet(ejbComponent.getComponentName());
        }
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Using security domain: " + securityDomainName + " for EJB " + ejbComponent.getComponentName());
        }
        return new SecurityDomainInterceptor(securityDomain);
    }
}

