/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.annotation;

import java.io.Serializable;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import org.jboss.as.ee.metadata.ClassAnnotationInformationFactory;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.metadata.property.PropertyReplacer;

public class ScheduleAnnotationInformationFactory
extends ClassAnnotationInformationFactory<Schedule, AutoTimer> {
    public ScheduleAnnotationInformationFactory() {
        super(Schedule.class, Schedules.class);
    }

    protected AutoTimer fromAnnotation(AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) {
        AutoTimer timer = new AutoTimer();
        for (ScheduleValues schedulePart : ScheduleValues.values()) {
            schedulePart.set(timer, annotationInstance, propertyReplacer);
        }
        return timer;
    }

    static enum ScheduleValues {
        DAY_OF_MONTH("dayOfMonth", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().dayOfMonth(value);
            }
        }
        ,
        DAY_OF_WEEK("dayOfWeek", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().dayOfWeek(value);
            }
        }
        ,
        HOUR("hour", "0"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().hour(value);
            }
        }
        ,
        INFO("info", null){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getTimerConfig().setInfo((Serializable)((Object)value));
            }
        }
        ,
        MINUTE("minute", "0"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().minute(value);
            }
        }
        ,
        MONTH("month", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().month(value);
            }
        }
        ,
        PERSISTENT("persistent", true){

            @Override
            protected void setBoolean(AutoTimer timer, boolean value) {
                timer.getTimerConfig().setPersistent(value);
            }
        }
        ,
        SECOND("second", "0"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().second(value);
            }
        }
        ,
        TIMEZONE("timezone", null){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().timezone(value);
            }
        }
        ,
        YEAR("year", "*"){

            @Override
            protected void setString(AutoTimer timer, String value) {
                timer.getScheduleExpression().year(value);
            }
        };

        private final String name;
        private final String defaultStringValue;
        private final boolean defaultBooleanValue;
        private final boolean booleanValue;

        private ScheduleValues(String name, String defaultStringValue) {
            this.name = name;
            this.defaultStringValue = defaultStringValue;
            this.defaultBooleanValue = false;
            this.booleanValue = false;
        }

        private ScheduleValues(String name, boolean defaultBooleanValue) {
            this.name = name;
            this.defaultStringValue = null;
            this.defaultBooleanValue = defaultBooleanValue;
            this.booleanValue = true;
        }

        public void set(AutoTimer timer, AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) {
            AnnotationValue value = annotationInstance.value(this.name);
            if (this.booleanValue) {
                if (value == null) {
                    this.setBoolean(timer, this.defaultBooleanValue);
                } else {
                    this.setBoolean(timer, value.asBoolean());
                }
            } else if (value == null) {
                this.setString(timer, this.defaultStringValue);
            } else {
                this.setString(timer, propertyReplacer.replaceProperties(value.asString()));
            }
        }

        protected void setString(AutoTimer expression, String value) {
            throw EjbLogger.ROOT_LOGGER.shouldBeOverridden();
        }

        protected void setBoolean(AutoTimer expression, boolean value) {
            throw EjbLogger.ROOT_LOGGER.shouldBeOverridden();
        }
    }
}

