/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.api.tools;

import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jboss.ws.api.tools.SecurityActions;
import org.jboss.ws.api.tools.WSContractConsumerFactory;
import org.jboss.ws.api.util.ServiceLoader;

public abstract class WSContractConsumer {
    private static String DEFAULT_PROVIDER = "org.jboss.wsf.stack.cxf.tools.CXFConsumerFactoryImpl";
    public static final String PROVIDER_PROPERTY = "org.jboss.ws.api.tools.ConsumerFactory";

    public static WSContractConsumer newInstance() {
        return WSContractConsumer.newInstance(SecurityActions.getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSContractConsumer newInstance(ClassLoader loader) {
        ClassLoader oldLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(loader);
            WSContractConsumerFactory factory = (WSContractConsumerFactory)ServiceLoader.loadService(PROVIDER_PROPERTY, DEFAULT_PROVIDER);
            WSContractConsumer wSContractConsumer = factory.createConsumer();
            return wSContractConsumer;
        }
        finally {
            SecurityActions.setContextClassLoader(oldLoader);
        }
    }

    public abstract void setBindingFiles(List<File> var1);

    public abstract void setCatalog(File var1);

    public abstract void setOutputDirectory(File var1);

    public abstract void setSourceDirectory(File var1);

    public abstract void setExtension(boolean var1);

    public abstract void setGenerateSource(boolean var1);

    public abstract void setNoCompile(boolean var1);

    public abstract void setTargetPackage(String var1);

    public abstract void setWsdlLocation(String var1);

    public abstract void setEncoding(String var1);

    public abstract void setMessageStream(PrintStream var1);

    public abstract void setAdditionalCompilerClassPath(List<String> var1);

    public abstract void setAdditionalHeaders(boolean var1);

    public abstract void setTarget(String var1);

    public abstract void setClientJar(File var1);

    public abstract void consume(URL var1);

    public void consume(String wsdl) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(wsdl);
        }
        catch (MalformedURLException e) {
            File file = new File(wsdl);
            url = file.toURI().toURL();
        }
        this.consume(url);
    }
}

