/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.util.AbstractMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;

public class AmqpSupport {
    public static final int AMQP_CREDITS_DEFAULT = 1000;
    public static final int AMQP_LOW_CREDITS_DEFAULT = 300;
    public static final boolean AMQP_TREAT_REJECT_AS_UNMODIFIED_DELIVERY_FAILURE = false;
    public static final boolean AMQP_USE_MODIFIED_FOR_TRANSIENT_DELIVERY_ERRORS = false;
    public static final UnsignedLong JMS_SELECTOR_CODE = UnsignedLong.valueOf((long)77567109365764L);
    public static final Symbol JMS_SELECTOR_NAME = Symbol.valueOf((String)"apache.org:selector-filter:string");
    public static final Object[] JMS_SELECTOR_FILTER_IDS = new Object[]{JMS_SELECTOR_CODE, JMS_SELECTOR_NAME};
    public static final UnsignedLong NO_LOCAL_CODE = UnsignedLong.valueOf((long)77567109365763L);
    public static final Symbol NO_LOCAL_NAME = Symbol.valueOf((String)"apache.org:no-local-filter:list");
    public static final Object[] NO_LOCAL_FILTER_IDS = new Object[]{NO_LOCAL_CODE, NO_LOCAL_NAME};
    public static final Symbol TEMP_QUEUE_CAPABILITY = Symbol.valueOf((String)"temporary-queue");
    public static final Symbol TEMP_TOPIC_CAPABILITY = Symbol.valueOf((String)"temporary-topic");
    public static final Symbol QUEUE_CAPABILITY = Symbol.valueOf((String)"queue");
    public static final Symbol TOPIC_CAPABILITY = Symbol.valueOf((String)"topic");
    public static final Symbol INVALID_FIELD = Symbol.valueOf((String)"invalid-field");
    public static final Symbol CONTAINER_ID = Symbol.valueOf((String)"container-id");
    public static final Symbol ANONYMOUS_RELAY = Symbol.valueOf((String)"ANONYMOUS-RELAY");
    public static final Symbol DELAYED_DELIVERY = Symbol.valueOf((String)"DELAYED_DELIVERY");
    public static final Symbol QUEUE_PREFIX = Symbol.valueOf((String)"queue-prefix");
    public static final Symbol TOPIC_PREFIX = Symbol.valueOf((String)"topic-prefix");
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf((String)"amqp:connection-establishment-failed");
    public static final Symbol PRODUCT = Symbol.valueOf((String)"product");
    public static final Symbol VERSION = Symbol.valueOf((String)"version");
    public static final Symbol PLATFORM = Symbol.valueOf((String)"platform");
    public static final Symbol RESOURCE_DELETED = Symbol.valueOf((String)"amqp:resource-deleted");
    public static final Symbol CONNECTION_FORCED = Symbol.valueOf((String)"amqp:connection:forced");
    public static final Symbol SHARED_SUBS = Symbol.valueOf((String)"SHARED-SUBS");
    public static final Symbol NETWORK_HOST = Symbol.valueOf((String)"network-host");
    public static final Symbol PORT = Symbol.valueOf((String)"port");
    static final Symbol SCHEME = Symbol.valueOf((String)"scheme");
    static final Symbol HOSTNAME = Symbol.valueOf((String)"hostname");
    static final Symbol FAILOVER_SERVER_LIST = Symbol.valueOf((String)"failover-server-list");
    public static final int MAX_FRAME_SIZE_DEFAULT = 131072;
    public static final Symbol COPY = Symbol.getSymbol((String)"copy");
    public static final Symbol LIFETIME_POLICY = Symbol.valueOf((String)"lifetime-policy");
    public static final Symbol SOLE_CONNECTION_CAPABILITY = Symbol.valueOf((String)"sole-connection-for-container");

    public static boolean contains(Symbol[] symbols, Symbol key) {
        if (symbols == null || symbols.length == 0) {
            return false;
        }
        for (Symbol symbol : symbols) {
            if (!symbol.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static Map.Entry<Symbol, DescribedType> findFilter(Map<Symbol, Object> filters, Object[] filterIds) {
        if (filterIds == null || filterIds.length == 0) {
            StringBuilder ids = new StringBuilder();
            if (filterIds != null) {
                for (Object filterId : filterIds) {
                    ids.append(filterId).append(" ");
                }
            }
            throw new IllegalArgumentException("Invalid Filter Ids array passed: " + ids);
        }
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        for (Map.Entry<Symbol, Object> filter : filters.entrySet()) {
            if (!(filter.getValue() instanceof DescribedType)) continue;
            DescribedType describedType = (DescribedType)filter.getValue();
            Object descriptor = describedType.getDescriptor();
            for (Object filterId : filterIds) {
                if (!descriptor.equals(filterId)) continue;
                return new AbstractMap.SimpleImmutableEntry<Symbol, DescribedType>(filter.getKey(), describedType);
            }
        }
        return null;
    }
}

