/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.ArrayList;
import org.jboss.as.clustering.controller.BinaryServiceNameFactory;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.IdentityCapabilityServiceConfigurator;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.server.IdentityCacheRequirementServiceConfiguratorProvider;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class IdentityRegistryFactoryServiceConfiguratorProvider
extends IdentityCacheRequirementServiceConfiguratorProvider {
    public IdentityRegistryFactoryServiceConfiguratorProvider() {
        super(ClusteringCacheRequirement.REGISTRY_FACTORY);
    }

    @Override
    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String aliasCacheName, String targetCacheName) {
        Iterable<CapabilityServiceConfigurator> configurators = super.getServiceConfigurators(registry, containerName, aliasCacheName, targetCacheName);
        ServiceName registryServiceName = registry.getServiceName((Requirement)ClusteringCacheRequirement.REGISTRY);
        ServiceName registryEntryServiceName = registry.getServiceName((Requirement)ClusteringCacheRequirement.REGISTRY_ENTRY);
        if (registryServiceName == null && registryEntryServiceName == null) {
            return configurators;
        }
        ArrayList<IdentityCapabilityServiceConfigurator> registryConfigurators = new ArrayList<IdentityCapabilityServiceConfigurator>(2);
        if (registryServiceName != null) {
            registryConfigurators.add(new IdentityCapabilityServiceConfigurator(registryServiceName, (BinaryServiceNameFactory)ClusteringCacheRequirement.REGISTRY, containerName, targetCacheName));
        }
        if (registryEntryServiceName != null) {
            registryConfigurators.add(new IdentityCapabilityServiceConfigurator(registryEntryServiceName, (BinaryServiceNameFactory)ClusteringCacheRequirement.REGISTRY_ENTRY, containerName, targetCacheName));
        }
        return new CompositeIterable(new Iterable[]{configurators, registryConfigurators});
    }
}

