/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Objects;
import javax.persistence.Id;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ByteBuddyEnhancementContext;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

final class FieldAccessEnhancer
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(FieldAccessEnhancer.class);
    private final TypeDescription managedCtClass;
    private final ByteBuddyEnhancementContext enhancementContext;
    private final TypePool classPool;

    FieldAccessEnhancer(TypeDescription managedCtClass, ByteBuddyEnhancementContext enhancementContext, TypePool classPool) {
        this.managedCtClass = managedCtClass;
        this.enhancementContext = enhancementContext;
        this.classPool = classPool;
    }

    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, final MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return new MethodVisitor(327680, methodVisitor){

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (opcode != 180 && opcode != 181) {
                    super.visitFieldInsn(opcode, owner, name, desc);
                    return;
                }
                EnhancerImpl.AnnotatedFieldDescription field = FieldAccessEnhancer.this.findField(owner, name, desc);
                if ((FieldAccessEnhancer.this.enhancementContext.isEntityClass(field.getDeclaringType().asErasure()) || FieldAccessEnhancer.this.enhancementContext.isCompositeClass(field.getDeclaringType().asErasure())) && !field.getType().asErasure().equals(FieldAccessEnhancer.this.managedCtClass) && FieldAccessEnhancer.this.enhancementContext.isPersistentField(field) && !field.hasAnnotation(Id.class) && !field.getName().equals("this$0")) {
                    log.debugf("Extended enhancement: Transforming access to field [%s.%s] from method [%s#%s]", new Object[]{field.getType().asErasure(), field.getName(), field.getName(), name});
                    switch (opcode) {
                        case 180: {
                            methodVisitor.visitMethodInsn(182, owner, "$$_hibernate_read_" + name, Type.getMethodDescriptor((Type)Type.getType((String)desc), (Type[])new Type[0]), false);
                            return;
                        }
                        case 181: {
                            methodVisitor.visitMethodInsn(182, owner, "$$_hibernate_write_" + name, Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType((String)desc)}), false);
                            return;
                        }
                    }
                    throw new EnhancementException("Unexpected opcode: " + opcode);
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        };
    }

    private EnhancerImpl.AnnotatedFieldDescription findField(String owner, String name, String desc) {
        String cleanedOwner = owner.replace('/', '.');
        TypePool.Resolution resolution = this.classPool.describe(cleanedOwner);
        if (!resolution.isResolved()) {
            String msg = String.format("Unable to perform extended enhancement - Unable to locate [%s]", cleanedOwner);
            throw new EnhancementException(msg);
        }
        FieldList fields = (FieldList)resolution.resolve().getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)name).and((ElementMatcher)ElementMatchers.hasDescriptor((String)desc)));
        if (fields.size() != 1) {
            String msg = String.format("Unable to perform extended enhancement - No unique field [%s] defined by [%s]", name, cleanedOwner);
            throw new EnhancementException(msg);
        }
        return new EnhancerImpl.AnnotatedFieldDescription(this.enhancementContext, (FieldDescription)fields.getOnly());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || FieldAccessEnhancer.class != o.getClass()) {
            return false;
        }
        FieldAccessEnhancer that = (FieldAccessEnhancer)o;
        return Objects.equals(this.managedCtClass, that.managedCtClass);
    }

    public int hashCode() {
        return this.managedCtClass.hashCode();
    }
}

