/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime._private;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleLoader;

@MessageLogger(projectCode="WFLYJAR", length=4)
public interface BootableJarLogger
extends BasicLogger {
    public static final BootableJarLogger ROOT_LOGGER = (BootableJarLogger)Logger.getMessageLogger(BootableJarLogger.class, (String)"org.wildfly.jar");

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1, value="Shutting down")
    public void shuttingDown();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2, value="Server stopped, exiting")
    public void serverStopped();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3, value="Server not yet stopped, waiting")
    public void serverNotStopped();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=4, value="Null controller client, exiting")
    public void nullController();

    @Message(id=5, value="Unexpected exception while shutting down server")
    public RuntimeException unexpectedExceptionWhileShuttingDown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Deployed %s in server")
    public void installDeployment(Path var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Installed server and application in %s, took %sms")
    public void advertiseInstall(Path var1, long var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="Server options: %s")
    public void advertiseOptions(List<String> var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=9, value="Deleting %s dir")
    public void deletingHome(Path var1);

    @Message(id=10, value="Not an hollow jar, deployment already exists")
    public Exception deploymentAlreadyExist();

    @Message(id=11, value="Unknown argument %s")
    public RuntimeException unknownArgument(String var1);

    @Message(id=12, value="File %s doesn't exist")
    public RuntimeException notExistingFile(String var1);

    @Message(id=13, value="Invalid argument %s, no value provided")
    public RuntimeException invalidArgument(String var1);

    @Message(id=14, value="The server is stopping and invocations on the ModelControllerClient are not available")
    public IllegalStateException processIsStopping();

    @Message(id=15, value="The server is reloading and invocations on the ModelControllerClient are not yet available")
    public IllegalStateException processIsReloading();

    @Message(id=16, value="The server is stopped and invocations on the ModelControllerClient are not available")
    public IllegalStateException processIsStopped();

    @Message(id=17, value="Cannot start server")
    public RuntimeException cannotStartServer(@Cause Throwable var1);

    @Message(id=18, value="Cannot load module %s from: %s")
    public RuntimeException moduleLoaderError(@Cause Throwable var1, String var2, ModuleLoader var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Cannot restart server, exiting")
    public void cantRestartServer();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Can't delete %s. Exception %s")
    public void cantDelete(String var1, IOException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Cannot register JBoss Modules MBeans, %s")
    public void cantRegisterModuleMBeans(Exception var1);

    @Message(id=22, value="The PID file %s already exists. This may result in the install directory \"%s\" not being properly deleted.")
    public IllegalStateException pidFileAlreadyExists(Path var1, Path var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23, value="Failed to start the cleanup processor. This may result in the install directory \"%s\" not being properly deleted.")
    public void failedToStartCleanupProcess(@Cause Throwable var1, Path var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=24, value="The container has not properly shutdown within %ds. This may result in the install directory \"%s\" not being properly deleted.")
    public void cleanupTimeout(long var1, Path var3);

    @Message(id=0, value="Set system property jboss.bind.address to the given value")
    public String argPublicBindAddress();

    @Message(id=0, value="Set system property jboss.bind.address.<interface> to the given value")
    public String argInterfaceBindAddress();

    @Message(id=0, value="Set a system property")
    public String argSystem();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set system property jboss.default.multicast.address to the given value")
    public String argDefaultMulticastAddress();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Activate the SecurityManager")
    public String argSecurityManager();

    @Message(id=0, value="Set a security property")
    public String argSecurityProperty();

    @Message(id=0, value="Path to deployment artifact (war,jar,ear or exploded deployment dir) to deploy in hollow jar")
    public String argDeployment();

    @Message(id=0, value="Path to directory in which the server is installed. By default the server is installed in TEMP directory.")
    public String argInstallation();

    @Message(id=0, value="Display the content of the Galleon configuration used to build this bootable JAR")
    public String argDisplayGalleonConfig();

    @Message(id=0, value="Path to a CLI script to execute when starting the Bootable JAR")
    public String argCliScript();
}

