/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.io.Serializable;

public class TableName
implements Serializable {
    private String identifierQuote;
    private String schema;
    private String tableName;

    public TableName(String identifierQuote, String tableNamePrefix, String cacheName) {
        if (identifierQuote == null) {
            throw new IllegalArgumentException("identifierQuote must not be null");
        }
        if (tableNamePrefix == null) {
            throw new IllegalArgumentException("tableNamePrefix must not be null");
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("cacheName must not be null");
        }
        this.identifierQuote = identifierQuote;
        this.normalize(tableNamePrefix, cacheName);
    }

    public String getIdentifierQuote() {
        return this.identifierQuote;
    }

    public void setIdentifierQuote(String identifierQuote) {
        this.identifierQuote = identifierQuote;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.tableName;
    }

    public String toString() {
        if (this.schema != null) {
            return this.identifierQuote + this.schema + this.identifierQuote + "." + this.identifierQuote + this.tableName + this.identifierQuote;
        }
        return this.identifierQuote + this.tableName + this.identifierQuote;
    }

    private void normalize(String tableNamePrefix, String cacheName) {
        cacheName = cacheName.replaceAll("[^\\p{Alnum}]", "_");
        String tableName = tableNamePrefix + "_" + cacheName;
        String[] tableNameParts = tableName.split("\\.", 2);
        if (tableNameParts.length != 1) {
            this.schema = tableNameParts[0];
            this.tableName = tableNameParts[1];
        } else {
            this.schema = null;
            this.tableName = tableNameParts[0];
        }
        if (this.schema != null && this.schema.isEmpty()) {
            throw new IllegalArgumentException("Schema inside table name prefix must not be empty.");
        }
    }
}

