/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import java.lang.reflect.AnnotatedElement;
import javax.xml.ws.Service;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.as.webservices.webserviceref.WSRefAnnotationWrapper;
import org.jboss.as.webservices.webserviceref.WSRefRegistry;
import org.jboss.as.webservices.webserviceref.WSRefUtils;
import org.jboss.as.webservices.webserviceref.WebServiceManagedReferenceFactory;
import org.jboss.modules.Module;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WebServiceReferences {
    public static ManagedReferenceFactory createWebServiceFactory(DeploymentUnit deploymentUnit, String targetType, WSRefAnnotationWrapper wsRefDescription, AnnotatedElement target, String bindingName) throws DeploymentUnitProcessingException {
        Assert.checkNotNullParam((String)"targetType", (Object)targetType);
        UnifiedServiceRefMetaData serviceRefUMDM = WebServiceReferences.createServiceRef(deploymentUnit, targetType, wsRefDescription, target, bindingName, bindingName);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        return new WebServiceManagedReferenceFactory(serviceRefUMDM, (ClassLoader)module.getClassLoader());
    }

    public static ManagedReferenceFactory createWebServiceFactory(DeploymentUnit deploymentUnit, String targetType, WSRefAnnotationWrapper wsRefDescription, AnnotatedElement target, String bindingName, String refKey) throws DeploymentUnitProcessingException {
        Assert.checkNotNullParam((String)"targetType", (Object)targetType);
        UnifiedServiceRefMetaData serviceRefUMDM = WebServiceReferences.createServiceRef(deploymentUnit, targetType, wsRefDescription, target, bindingName, refKey);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        return new WebServiceManagedReferenceFactory(serviceRefUMDM, (ClassLoader)module.getClassLoader());
    }

    private static UnifiedServiceRefMetaData createServiceRef(DeploymentUnit unit, String type, WSRefAnnotationWrapper annotation, AnnotatedElement annotatedElement, String bindingName, String refKey) throws DeploymentUnitProcessingException {
        WSRefRegistry wsRefRegistry = ASHelper.getWSRefRegistry(unit);
        UnifiedServiceRefMetaData serviceRefUMDM = wsRefRegistry.get(refKey);
        if (serviceRefUMDM == null) {
            serviceRefUMDM = new UnifiedServiceRefMetaData(WebServiceReferences.getUnifiedVirtualFile(unit), bindingName);
            wsRefRegistry.add(refKey, serviceRefUMDM);
        }
        WebServiceReferences.initServiceRef(unit, serviceRefUMDM, type, annotation);
        WebServiceReferences.processWSFeatures(serviceRefUMDM, annotatedElement);
        return serviceRefUMDM;
    }

    private static void processWSFeatures(UnifiedServiceRefMetaData serviceRefUMDM, AnnotatedElement annotatedElement) throws DeploymentUnitProcessingException {
        WSRefUtils.processAnnotatedElement(annotatedElement, serviceRefUMDM);
    }

    private static UnifiedServiceRefMetaData initServiceRef(DeploymentUnit unit, UnifiedServiceRefMetaData serviceRefUMDM, String type, WSRefAnnotationWrapper annotation) throws DeploymentUnitProcessingException {
        if (!WebServiceReferences.isEmpty(annotation.wsdlLocation())) {
            serviceRefUMDM.setWsdlFile(annotation.wsdlLocation());
        }
        Module module = (Module)unit.getAttachment(Attachments.MODULE);
        Class<?> typeClass = WebServiceReferences.getClass(module, type);
        serviceRefUMDM.setServiceRefType(typeClass.getName());
        if (!WebServiceReferences.isEmpty(annotation.value())) {
            serviceRefUMDM.setServiceInterface(annotation.value());
        } else if (Service.class.isAssignableFrom(typeClass)) {
            serviceRefUMDM.setServiceInterface(typeClass.getName());
        } else {
            serviceRefUMDM.setServiceInterface(Service.class.getName());
        }
        return serviceRefUMDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClass(Module module, String className) throws DeploymentUnitProcessingException {
        ClassLoader oldCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            if (!WebServiceReferences.isEmpty(className)) {
                try {
                    Class clazz = module.getClassLoader().loadClass(className);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException((Throwable)e);
                }
            }
            Class<?> clazz = null;
            return clazz;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCL);
        }
    }

    private static UnifiedVirtualFile getUnifiedVirtualFile(DeploymentUnit unit) {
        ResourceRoot resourceRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        return new VirtualFileAdaptor(resourceRoot.getRoot());
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private WebServiceReferences() {
    }
}

