/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.calendar.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.calendar.model.Schedulable;
import java.util.Date;

public class ToDoHeader
extends Schedulable
implements Cloneable {
    public static final int PERCENT_UNDEFINED = -1;
    public static final int DURATION_UNDEFINED = -1;
    private int percentCompleted = -1;
    private Date completedDate = null;
    private String componentId = null;
    private String spaceId = null;
    private String externalId = null;
    private int duration = -1;

    public ToDoHeader() {
    }

    public ToDoHeader(String name, String organizerId) {
        super(name, organizerId);
    }

    public ToDoHeader(String id, String name, String organizerId) {
        super(id, name, organizerId);
    }

    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    public void setPercentCompleted(int newValue) {
        this.percentCompleted = newValue;
    }

    public void setCompletedDate(Date date) {
        this.completedDate = date;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDay(String day) {
        try {
            this.completedDate = dateFormat.parse(day);
        }
        catch (Exception e) {
            SilverTrace.warn((String)"calendar", (String)"ToDoHeader.setCompletedDay(String day)", (String)"calendar_MSG_NOT_PARSE_DATE", (String)"return => completedDate=null");
            this.completedDate = null;
        }
    }

    public String getCompletedDay() {
        if (this.completedDate == null) {
            return null;
        }
        return dateFormat.format(this.completedDate);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setSpaceId(String id) {
        this.spaceId = id;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public void setExternalId(String id) {
        this.externalId = id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public Schedulable getCopy() {
        try {
            return (ToDoHeader)this.clone();
        }
        catch (Exception e) {
            SilverTrace.warn((String)"calendar", (String)"ToDoHeader.getCopy", (String)"calendar_MSG_NOT_Get_COPY", (String)"return => Schedulable=null");
            return null;
        }
    }
}

