/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleSQLOutput
implements SQLOutput {
    private StructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private oracle.jdbc.OracleConnection conn;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    public OracleSQLOutput(StructDescriptor structDescriptor, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this.descriptor = structDescriptor;
        this.attributes = new Object[structDescriptor.getLength()];
        this.conn = oracleConnection;
        this.index = 0;
    }

    public STRUCT getSTRUCT() throws SQLException {
        return new STRUCT(this.descriptor, (Connection)this.conn, this.attributes);
    }

    @Override
    public void writeString(String string) throws SQLException {
        this.attributes[this.index++] = string;
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.attributes[this.index++] = bl;
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.attributes[this.index++] = (int)by;
    }

    @Override
    public void writeShort(short s2) throws SQLException {
        this.attributes[this.index++] = (int)s2;
    }

    @Override
    public void writeInt(int n2) throws SQLException {
        this.attributes[this.index++] = n2;
    }

    @Override
    public void writeLong(long l2) throws SQLException {
        this.attributes[this.index++] = new Long(l2);
    }

    @Override
    public void writeFloat(float f2) throws SQLException {
        this.attributes[this.index++] = new Float(f2);
    }

    @Override
    public void writeDouble(double d2) throws SQLException {
        this.attributes[this.index++] = new Double(d2);
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.attributes[this.index++] = bigDecimal;
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        this.attributes[this.index++] = byArray;
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.attributes[this.index++] = date;
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.attributes[this.index++] = time;
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attributes[this.index++] = timestamp;
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[100];
        int n2 = 0;
        try {
            while ((n2 = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string = stringBuffer.substring(0, stringBuffer.length());
        this.attributes[this.index++] = string;
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[100];
        char[] cArray = new char[100];
        int n2 = 0;
        try {
            while ((n2 = inputStream.read(byArray)) != -1) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    cArray[i2] = (char)byArray[i2];
                }
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string = stringBuffer.substring(0, stringBuffer.length());
        this.attributes[this.index++] = string;
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        this.writeAsciiStream(inputStream);
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        STRUCT sTRUCT = null;
        if (sQLData != null) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), (Connection)this.conn);
            SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
            sQLData.writeSQL(sQLOutput);
            sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
        }
        this.writeStruct(sTRUCT);
    }

    public void writeObject(Object object) throws SQLException {
        if (object != null && object instanceof SQLData) {
            this.writeObject((SQLData)object);
        } else {
            this.attributes[this.index++] = object;
        }
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        this.attributes[this.index++] = ref;
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        this.attributes[this.index++] = blob;
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        this.attributes[this.index++] = clob;
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        this.attributes[this.index++] = struct;
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        this.attributes[this.index++] = array;
    }

    public void writeOracleObject(Datum datum) throws SQLException {
        this.attributes[this.index++] = datum;
    }

    public void writeRef(REF rEF) throws SQLException {
        this.attributes[this.index++] = rEF;
    }

    public void writeBlob(BLOB bLOB) throws SQLException {
        this.attributes[this.index++] = bLOB;
    }

    public void writeBfile(BFILE bFILE) throws SQLException {
        this.attributes[this.index++] = bFILE;
    }

    public void writeClob(CLOB cLOB) throws SQLException {
        this.attributes[this.index++] = cLOB;
    }

    public void writeStruct(STRUCT sTRUCT) throws SQLException {
        this.attributes[this.index++] = sTRUCT;
    }

    public void writeArray(ARRAY aRRAY) throws SQLException {
        this.attributes[this.index++] = aRRAY;
    }

    public void writeNUMBER(NUMBER nUMBER) throws SQLException {
        this.attributes[this.index++] = nUMBER;
    }

    public void writeCHAR(CHAR cHAR) throws SQLException {
        this.attributes[this.index++] = cHAR;
    }

    public void writeDATE(DATE dATE) throws SQLException {
        this.attributes[this.index++] = dATE;
    }

    public void writeRAW(RAW rAW) throws SQLException {
        this.attributes[this.index++] = rAW;
    }

    public void writeROWID(ROWID rOWID) throws SQLException {
        this.attributes[this.index++] = rOWID;
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        this.writeClob(nClob);
    }

    @Override
    public void writeNString(String string) throws SQLException {
        this.writeString(string);
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        this.writeObject(sQLXML);
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        this.writeROWID((ROWID)rowId);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

