(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    define(["converse"], factory);
  } else {
    factory(converse);
  }
}(this, function(converse) {
  let _converse;
  converse.plugins.add("silverpeas-commons", {
    dependencies : [],
    initialize : function() {
      _converse = this._converse;
      if (!converse.env.spUtils) {
        converse.env.spUtils = {
          getChatViewFromElement : function($el) {
            return $el.closest('converse-chat.chatbox') || $el.closest('converse-muc.chatbox');
          },
          minChats : new function() {
            const _getView = function() {
              return document.querySelector("converse-minimized-chats");
            };
            const _getModel = function() {
              return _getView()?.minchats;
            };
            this.collapse = function() {
              const minChats = _getModel();
              if (minChats && minChats.get('collapsed') !== true) {
                minChats.save({'collapsed' : true}).then(function() {
                  _getView().requestUpdate();
                });
              }
            }
          },
          muc : {
            getAutoCompleteListItem : function(text, input) {
              input = input.trim();
              text = text.trim();
              const element = document.createElement('li');
              element.setAttribute('aria-label', text);
              element.setAttribute('aria-basket', 'false');
              element.setAttribute('aria-selected', 'false');
              if (_converse.api.settings.get('muc_mention_autocomplete_show_avatar')) {
                const img = document.createElement('img');
                let dataUri = 'data:' + _converse.DEFAULT_IMAGE_TYPE + ';base64,' + _converse.DEFAULT_IMAGE;
                if (_converse.vcards) {
                  const vcard = _converse.vcards.findWhere({'nickname' : text});
                  if (vcard) {
                    dataUri = 'data:' + vcard.get('image_type') + ';base64,' + vcard.get('image');
                  }
                }
                img.setAttribute('src', dataUri);
                img.setAttribute('width', '22');
                img.setAttribute('class', 'avatar avatar-autocomplete');
                element.appendChild(img);
              }
              const regex = new RegExp('(' + input + ')', 'ig');
              const parts = input ? text.split(regex) : [text];
              parts.forEach(function(txt) {
                if (input && txt.match(regex)) {
                  const match = document.createElement('mark');
                  match.textContent = txt;
                  element.appendChild(match);
                } else {
                  element.appendChild(document.createTextNode(txt));
                }
              });
              return element;
            }
          }
        }
      }
    }
  });
}));
