/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.psu.swe.scim.spec.resources.ScimResource;
import edu.psu.swe.scim.spec.schema.ResourceType;
import edu.psu.swe.scim.spec.schema.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class Registry {
    private static final Logger log = LoggerFactory.getLogger(Registry.class);
    private Map<String, Schema> schemaMap = new HashMap<String, Schema>();
    private Map<String, Class<? extends ScimResource>> schemaUrnToScimResourceClass = new HashMap<String, Class<? extends ScimResource>>();
    private Map<String, Class<? extends ScimResource>> endpointToScimResourceClass = new HashMap<String, Class<? extends ScimResource>>();
    private Map<String, ResourceType> resourceTypeMap = new HashMap<String, ResourceType>();
    private ObjectMapper objectMapper;

    public Schema getSchema(String urn) {
        return this.schemaMap.get(urn);
    }

    public Set<String> getAllSchemaUrns() {
        return Collections.unmodifiableSet(this.schemaMap.keySet());
    }

    public Collection<Schema> getAllSchemas() {
        return Collections.unmodifiableCollection(this.schemaMap.values());
    }

    public Schema getBaseSchemaOfResourceType(String resourceType) {
        ResourceType rt = this.resourceTypeMap.get(resourceType);
        if (rt == null) {
            return null;
        }
        String schemaUrn = rt.getSchemaUrn();
        return this.schemaMap.get(schemaUrn);
    }

    public void addSchema(Schema schema) throws JsonProcessingException {
        log.info("Adding schema " + schema.getId() + " into the registry");
        this.schemaMap.put(schema.getId(), schema);
    }

    public void addSchemaDoc(String schemaDoc) {
        try {
            Schema schema = (Schema)this.objectMapper.readValue(schemaDoc, Schema.class);
            this.schemaMap.put(schema.getId(), schema);
        }
        catch (Throwable t) {
            log.error("Unexpected Throwable was caught while unmarshalling JSON, schema will not be added: " + t.getLocalizedMessage());
        }
    }

    public <T extends ScimResource> void addScimResourceSchemaUrn(String schemaUrn, Class<T> scimResourceClass) {
        this.schemaUrnToScimResourceClass.put(schemaUrn, scimResourceClass);
    }

    public <T extends ScimResource> void addScimResourceEndPoint(String endpoint, Class<T> scimResourceClass) {
        this.endpointToScimResourceClass.put(endpoint, scimResourceClass);
    }

    public <T extends ScimResource> Class<T> findScimResourceClassFromEndpoint(String endpoint) {
        Class<? extends ScimResource> scimResourceClass = this.endpointToScimResourceClass.get(endpoint);
        return scimResourceClass;
    }

    public <T extends ScimResource> Class<T> findScimResourceClass(String schemaUrn) {
        Class<? extends ScimResource> scimResourceClass = this.schemaUrnToScimResourceClass.get(schemaUrn);
        return scimResourceClass;
    }

    public ResourceType getResourceType(String name) {
        return this.resourceTypeMap.get(name);
    }

    public Collection<ResourceType> getAllResourceTypes() {
        return Collections.unmodifiableCollection(this.resourceTypeMap.values());
    }

    public void addResourceType(ResourceType resourceType) {
        this.resourceTypeMap.put(resourceType.getName(), resourceType);
    }
}

