/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.questionreply.model.Recipient;
import org.silverpeas.components.questionreply.model.Reply;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.annotation.NonNull;

public class Question
extends SilverpeasBean {
    public static final int CLOSED = 2;
    public static final int NEW = 0;
    public static final int WAITING = 1;
    private static final long serialVersionUID = 8690405914141003827L;
    private String title;
    private String content;
    private String creatorId;
    private String creationDate;
    private int status = 0;
    private int publicReplyNumber = 0;
    private int privateReplyNumber = 0;
    private int replyNumber = 0;
    private String instanceId;
    private String categoryId;
    private List<Reply> replies = new ArrayList<Reply>();
    private List<Recipient> recipients = new ArrayList<Recipient>();

    public Question() {
    }

    public Question(String creatorId, String instanceId) {
        this.creatorId = creatorId;
        this.instanceId = instanceId;
        this.setCreationDate();
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public int getStatus() {
        return this.status;
    }

    public int getPublicReplyNumber() {
        return this.publicReplyNumber;
    }

    public int getPrivateReplyNumber() {
        return this.privateReplyNumber;
    }

    public int getReplyNumber() {
        return this.replyNumber;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<Reply> readReplies() {
        return this.replies;
    }

    public List<Recipient> readRecipients() {
        return this.recipients;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public final void setCreationDate() {
        this.creationDate = DateUtil.date2SQLDate((Date)new Date());
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setPublicReplyNumber(int publicReplyNumber) {
        this.publicReplyNumber = publicReplyNumber;
    }

    public void setPrivateReplyNumber(int privateReplyNumber) {
        this.privateReplyNumber = privateReplyNumber;
    }

    public void setReplyNumber(int replyNumber) {
        this.replyNumber = replyNumber;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void writeReplies(Collection<Reply> replies) {
        this.replies = new ArrayList<Reply>(replies);
    }

    public void writeRecipients(Collection<Recipient> recipients) {
        this.recipients = new ArrayList<Recipient>(recipients);
    }

    public String getPermalink() {
        return URLUtil.getSimpleURL((int)6, (String)this.getPK().getId(), (boolean)false);
    }

    public String getURL() {
        return "searchResult?Type=Question&Id=" + this.getPK().getId();
    }

    public String readCreatorName() {
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        return this.readCreatorName(organizationController);
    }

    public String readCreatorName(OrganizationController organizationController) {
        String creatorName = null;
        UserDetail userDetail = this.readAuthor(organizationController);
        if (userDetail != null) {
            creatorName = userDetail.getDisplayedName();
        }
        return creatorName;
    }

    public UserDetail readAuthor(OrganizationController organizationController) {
        return (UserDetail)organizationController.getUserDetail(this.getCreatorId());
    }

    @NonNull
    protected String getTableName() {
        return "SC_QuestionReply_Question";
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public boolean hasWaitingStatus() {
        return this.status == 1;
    }

    public boolean hasClosedStatus() {
        return this.status == 2;
    }

    public boolean hasNewStatus() {
        return this.status == 0;
    }

    public void close() {
        this.status = 2;
    }

    public void waitForAnswer() {
        this.status = 1;
    }

    public String toString() {
        return "Question{title=" + this.title + ", content=" + this.content + ", creatorId=" + this.creatorId + ", creationDate=" + this.creationDate + ", status=" + this.status + ", publicReplyNumber=" + this.publicReplyNumber + ", privateReplyNumber=" + this.privateReplyNumber + ", replyNumber=" + this.replyNumber + ", instanceId=" + this.instanceId + ", categoryId=" + this.categoryId + ", replies=" + String.valueOf(this.replies) + ", recipients=" + String.valueOf(this.recipients) + "}";
    }
}

