/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.stats.QueryStatsData;
import org.apache.jackrabbit.oak.query.stats.QueryStatsMBean;
import org.apache.jackrabbit.oak.query.stats.QueryStatsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStatsMBeanImpl
extends AnnotatedStandardMBean
implements QueryStatsMBean,
QueryStatsReporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int SLOW_QUERY_LIMIT_SCANNED = Integer.getInteger("oak.query.slowScanLimit", 5000);
    private final int MAX_STATS_DATA = Integer.getInteger("oak.query.stats", 5000);
    private final int MAX_POPULAR_QUERIES = Integer.getInteger("oak.query.slowLimit", 100);
    private final int MAX_QUERY_SIZE = Integer.getInteger("oak.query.maxQuerySize", 2048);
    private final ConcurrentSkipListMap<String, QueryStatsData> statistics = new ConcurrentSkipListMap();
    private final QueryEngineSettings settings;
    private boolean captureStackTraces;
    private int evictionCount;

    public QueryStatsMBeanImpl(QueryEngineSettings settings) {
        super(QueryStatsMBean.class);
        this.settings = settings;
    }

    @Override
    public TabularData getSlowQueries() {
        ArrayList<QueryStatsData> list = new ArrayList<QueryStatsData>();
        long maxScanned = Math.min((long)this.SLOW_QUERY_LIMIT_SCANNED, this.settings.getLimitReads());
        for (QueryStatsData s : this.statistics.values()) {
            if (s.getMaxRowsScanned() <= maxScanned) continue;
            list.add(s);
        }
        Collections.sort(list, new Comparator<QueryStatsData>(){

            @Override
            public int compare(QueryStatsData o1, QueryStatsData o2) {
                return -Long.compare(o1.getMaxRowsScanned(), o2.getMaxRowsScanned());
            }
        });
        return this.asTabularData(list);
    }

    @Override
    public TabularData getPopularQueries() {
        ArrayList<QueryStatsData> list = new ArrayList<QueryStatsData>(this.statistics.values());
        Collections.sort(list, new Comparator<QueryStatsData>(){

            @Override
            public int compare(QueryStatsData o1, QueryStatsData o2) {
                return -Long.compare(o1.getTotalTimeNanos(), o2.getTotalTimeNanos());
            }
        });
        while (list.size() > this.MAX_POPULAR_QUERIES) {
            list.remove(list.size() - 1);
        }
        return this.asTabularData(list);
    }

    @Override
    public void resetStats() {
        this.statistics.clear();
    }

    @Override
    public void setCaptureStackTraces(boolean captureStackTraces) {
        this.captureStackTraces = captureStackTraces;
    }

    @Override
    public boolean getCaptureStackTraces() {
        return this.captureStackTraces;
    }

    @Override
    public String asJson() {
        ArrayList<QueryStatsData> list = new ArrayList<QueryStatsData>(this.statistics.values());
        Collections.sort(list, new Comparator<QueryStatsData>(){

            @Override
            public int compare(QueryStatsData o1, QueryStatsData o2) {
                return -Long.compare(o1.getTotalTimeNanos(), o2.getTotalTimeNanos());
            }
        });
        StringBuilder buff = new StringBuilder();
        buff.append("[\n");
        int i = 0;
        for (QueryStatsData s : list) {
            if (i++ > 0) {
                buff.append(",\n");
            }
            buff.append(s.toString());
        }
        return buff.append("\n]\n").toString();
    }

    @Override
    public QueryStatsData.QueryExecutionStats getQueryExecution(String statement, String language) {
        QueryStatsData stats;
        QueryStatsData s2;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Execute " + language + " / " + statement);
        }
        if (this.statistics.size() > 2 * this.MAX_STATS_DATA) {
            this.evict();
        }
        if (statement.length() > this.MAX_QUERY_SIZE) {
            statement = "Truncated query: " + statement.substring(0, this.MAX_QUERY_SIZE >> 1) + " ...... " + statement.substring(statement.length() - (this.MAX_QUERY_SIZE >> 1));
        }
        if ((s2 = this.statistics.putIfAbsent((stats = new QueryStatsData(statement, language)).getKey(), stats)) != null) {
            stats = s2;
        }
        stats.setCaptureStackTraces(this.captureStackTraces);
        return stats.new QueryStatsData.QueryExecutionStats();
    }

    private void evict() {
        ++this.evictionCount;
        ArrayList<QueryStatsData> list = new ArrayList<QueryStatsData>(this.statistics.values());
        Collections.sort(list, new Comparator<QueryStatsData>(){

            @Override
            public int compare(QueryStatsData o1, QueryStatsData o2) {
                int comp = -Long.compare(o1.getTotalTimeNanos(), o2.getTotalTimeNanos());
                if (comp == 0) {
                    comp = -Long.compare(o1.getCreatedMillis(), o2.getCreatedMillis());
                }
                return comp;
            }
        });
        Collections.sort(list.subList(this.MAX_STATS_DATA / 2, this.MAX_STATS_DATA), new Comparator<QueryStatsData>(){

            @Override
            public int compare(QueryStatsData o1, QueryStatsData o2) {
                return -Long.compare(o1.getCreatedMillis(), o2.getCreatedMillis());
            }
        });
        for (int i = this.MAX_STATS_DATA; i < list.size(); ++i) {
            this.statistics.remove(list.get(i).getKey());
        }
    }

    public int getEvictionCount() {
        return this.evictionCount;
    }

    private TabularData asTabularData(ArrayList<QueryStatsData> list) {
        TabularDataSupport tds = null;
        try {
            CompositeType ct = QueryStatsCompositeTypeFactory.getCompositeType();
            TabularType tt = new TabularType(QueryStatsData.class.getName(), "Query History", ct, QueryStatsCompositeTypeFactory.index);
            tds = new TabularDataSupport(tt);
            int position = 1;
            for (QueryStatsData q : list) {
                tds.put(new CompositeDataSupport(ct, QueryStatsCompositeTypeFactory.names, QueryStatsCompositeTypeFactory.getValues(q, position++)));
            }
            return tds;
        }
        catch (Exception e) {
            this.log.debug("Error", (Throwable)e);
            return null;
        }
    }

    private static class QueryStatsCompositeTypeFactory {
        private static final String[] index = new String[]{"position"};
        private static final String[] names = new String[]{"position", "maxTimeMillis", "totalTimeMillis", "executeCount", "rowsRead", "rowsScanned", "maxRowsRead", "maxRowsScanned", "language", "statement", "lastExecuted", "lastThread"};
        private static final String[] descriptions = names;
        private static final OpenType[] types = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};

        private QueryStatsCompositeTypeFactory() {
        }

        public static CompositeType getCompositeType() throws OpenDataException {
            return new CompositeType(QueryStatsMBean.class.getName(), QueryStatsMBean.class.getName(), names, descriptions, types);
        }

        public static Object[] getValues(QueryStatsData q, int position) {
            return new Object[]{(long)position, q.getMaxTimeNanos() / 1000000L, q.getTotalTimeNanos() / 1000000L, q.getExecuteCount(), q.getTotalRowsRead(), q.getTotalRowsScanned(), q.getMaxRowsRead(), q.getMaxRowsScanned(), q.getLanguage(), q.getQuery(), QueryStatsData.getTimeString(q.getLastExecutedMillis()), q.isInternal() ? "(internal query)" : q.getLastThreadName()};
        }
    }
}

