/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstElementFactory;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ComparisonImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.InImpl;
import org.apache.jackrabbit.oak.query.ast.NotImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextOr;

public class OrImpl
extends ConstraintImpl {
    private final List<ConstraintImpl> constraints;

    public OrImpl(List<ConstraintImpl> constraints) {
        Validate.checkArgument((!constraints.isEmpty() ? 1 : 0) != 0);
        this.constraints = constraints;
    }

    public OrImpl(ConstraintImpl constraint1, ConstraintImpl constraint2) {
        this(Arrays.asList(constraint1, constraint2));
    }

    public List<ConstraintImpl> getConstraints() {
        return this.constraints;
    }

    @Override
    public ConstraintImpl simplify() {
        LinkedHashSet values;
        ConstraintImpl simple;
        LinkedHashSet<ConstraintImpl> simplified = new LinkedHashSet<ConstraintImpl>();
        boolean changed = false;
        for (ConstraintImpl constraint : this.constraints) {
            simple = constraint.simplify();
            if (simple instanceof OrImpl) {
                simplified.addAll(((OrImpl)simple).constraints);
                changed = true;
                continue;
            }
            if (simplified.add(simple)) {
                changed = changed || simple != constraint;
                continue;
            }
            changed = true;
        }
        LinkedHashMap<DynamicOperandImpl, LinkedHashSet<StaticOperandImpl>> in = new LinkedHashMap<DynamicOperandImpl, LinkedHashSet<StaticOperandImpl>>();
        Iterator iterator = simplified.iterator();
        while (iterator.hasNext()) {
            DynamicOperandImpl o;
            simple = (ConstraintImpl)iterator.next();
            if (simple instanceof ComparisonImpl && ((ComparisonImpl)simple).getOperator() == Operator.EQUAL) {
                o = ((ComparisonImpl)simple).getOperand1();
                values = (LinkedHashSet)in.get(o);
                if (values == null) {
                    values = new LinkedHashSet();
                    in.put(o, values);
                }
                values.add(((ComparisonImpl)simple).getOperand2());
                iterator.remove();
                changed = true;
                continue;
            }
            if (!(simple instanceof InImpl)) continue;
            o = ((InImpl)simple).getOperand1();
            values = (LinkedHashSet)in.get(o);
            if (values == null) {
                values = new LinkedHashSet();
                in.put(o, values);
            }
            values.addAll(((InImpl)simple).getOperand2());
            iterator.remove();
            changed = true;
        }
        for (Map.Entry entry : in.entrySet()) {
            values = (LinkedHashSet)entry.getValue();
            if (values.size() == 1) {
                simplified.add(new ComparisonImpl((DynamicOperandImpl)entry.getKey(), Operator.EQUAL, (StaticOperandImpl)values.iterator().next()));
                continue;
            }
            simplified.add(new InImpl((DynamicOperandImpl)entry.getKey(), new ArrayList<StaticOperandImpl>(values)));
        }
        if (simplified.size() == 1) {
            return (ConstraintImpl)simplified.iterator().next();
        }
        if (changed) {
            return new OrImpl(new ArrayList<ConstraintImpl>(simplified));
        }
        return this;
    }

    @Override
    ConstraintImpl not() {
        ArrayList<ConstraintImpl> list = new ArrayList<ConstraintImpl>();
        for (ConstraintImpl constraint : this.getConstraints()) {
            list.add(new NotImpl(constraint));
        }
        return new AndImpl(list).simplify();
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        HashSet<PropertyExistenceImpl> result = null;
        for (ConstraintImpl constraint : this.constraints) {
            if (result == null) {
                result = new HashSet<PropertyExistenceImpl>(constraint.getPropertyExistenceConditions());
                continue;
            }
            result.retainAll(constraint.getPropertyExistenceConditions());
        }
        return result;
    }

    @Override
    public FullTextExpression getFullTextConstraint(SelectorImpl s) {
        ArrayList<FullTextExpression> list = new ArrayList<FullTextExpression>();
        for (ConstraintImpl constraint : this.constraints) {
            FullTextExpression expression = constraint.getFullTextConstraint(s);
            if (expression != null) {
                list.add(expression);
                continue;
            }
            return null;
        }
        return new FullTextOr(list);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        HashSet<SelectorImpl> result = new HashSet<SelectorImpl>();
        for (ConstraintImpl constraint : this.constraints) {
            result.addAll(constraint.getSelectors());
        }
        return result;
    }

    @Override
    public boolean evaluate() {
        for (ConstraintImpl constraint : this.constraints) {
            if (!constraint.evaluate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluateStop() {
        for (ConstraintImpl constraint : this.constraints) {
            if (constraint.evaluateStop()) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    @Override
    public void restrict(FilterImpl f) {
        Set<PropertyExistenceImpl> set = this.getPropertyExistenceConditions();
        if (!set.isEmpty()) {
            for (PropertyExistenceImpl p : set) {
                p.restrict(f);
            }
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        this.restrictPushDownNotExists(s);
        this.restrictPushDownInList(s);
    }

    private void restrictPushDownNotExists(SelectorImpl s) {
        Set<PropertyExistenceImpl> set = this.getPropertyExistenceConditions();
        if (set.isEmpty()) {
            return;
        }
        for (PropertyExistenceImpl p : set) {
            p.restrictPushDown(s);
        }
    }

    private void restrictPushDownInList(SelectorImpl s) {
        DynamicOperandImpl operand = null;
        LinkedHashSet<StaticOperandImpl> values = new LinkedHashSet<StaticOperandImpl>();
        boolean multiPropertyOr = false;
        ArrayList<AndImpl> ands = new ArrayList<AndImpl>();
        for (ConstraintImpl constraint : this.constraints) {
            DynamicOperandImpl o;
            Set<SelectorImpl> selectors = constraint.getSelectors();
            if (selectors.size() != 1 || !selectors.contains(s)) {
                return;
            }
            if (constraint instanceof AndImpl) {
                ands.add((AndImpl)constraint);
                continue;
            }
            if (constraint instanceof InImpl) {
                InImpl in = (InImpl)constraint;
                o = in.getOperand1();
                if (operand == null || operand.equals(o)) {
                    operand = o;
                    values.addAll(in.getOperand2());
                    continue;
                }
                multiPropertyOr = true;
                continue;
            }
            if (constraint instanceof ComparisonImpl && ((ComparisonImpl)constraint).getOperator() == Operator.EQUAL) {
                ComparisonImpl comparison = (ComparisonImpl)constraint;
                o = comparison.getOperand1();
                if (operand == null || operand.equals(o)) {
                    operand = o;
                    values.add(comparison.getOperand2());
                    continue;
                }
                multiPropertyOr = true;
                continue;
            }
            return;
        }
        if (multiPropertyOr && ands.isEmpty()) {
            s.restrictSelector(this);
            return;
        }
        if (operand == null) {
            return;
        }
        for (AndImpl and : ands) {
            boolean found = false;
            for (ConstraintImpl constraint : and.getConstraints()) {
                ComparisonImpl comparison;
                if (constraint instanceof InImpl) {
                    InImpl in = (InImpl)constraint;
                    if (!operand.equals(in.getOperand1())) continue;
                    values.addAll(in.getOperand2());
                    found = true;
                    break;
                }
                if (!(constraint instanceof ComparisonImpl) || ((ComparisonImpl)constraint).getOperator() != Operator.EQUAL || !operand.equals((comparison = (ComparisonImpl)constraint).getOperand1())) continue;
                values.add(comparison.getOperand2());
                found = true;
                break;
            }
            if (found) continue;
            return;
        }
        InImpl in = new InImpl(operand, new ArrayList<StaticOperandImpl>(values));
        in.setQuery(this.query);
        in.restrictPushDown(s);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ConstraintImpl constraint : this.constraints) {
            if (builder.length() > 0) {
                builder.append(" or ");
            }
            builder.append(this.protect(constraint));
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof OrImpl) {
            return this.constraints.equals(((OrImpl)that).constraints);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.constraints.hashCode();
    }

    @Override
    public AstElement copyOf() {
        ArrayList<ConstraintImpl> clone = new ArrayList<ConstraintImpl>();
        for (ConstraintImpl c : this.constraints) {
            clone.add((ConstraintImpl)AstElementFactory.copyElementAndCheckReference(c));
        }
        return new OrImpl(clone);
    }

    @Override
    public Set<ConstraintImpl> convertToUnion() {
        HashSet<ConstraintImpl> result = new HashSet<ConstraintImpl>();
        for (ConstraintImpl c : this.getConstraints()) {
            Set<ConstraintImpl> converted = c.convertToUnion();
            if (converted.isEmpty()) {
                result.add(c);
                continue;
            }
            result.addAll(converted);
        }
        return result;
    }

    @Override
    public boolean requiresFullTextIndex() {
        for (ConstraintImpl c : this.getConstraints()) {
            if (!c.requiresFullTextIndex()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsUnfilteredFullTextCondition() {
        boolean fulltext = false;
        boolean plain = false;
        for (ConstraintImpl c : this.constraints) {
            if (c.containsUnfilteredFullTextCondition()) {
                return true;
            }
            if (c.requiresFullTextIndex()) {
                fulltext = true;
            } else {
                plain = true;
            }
            if (!fulltext || !plain) continue;
            return true;
        }
        return false;
    }
}

